/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.meters.TagsCache;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class Gauges<T> {
    private static final Object VALUE_SUPPLIER = new Object();
    private final String name;
    private final String description;
    private final Label[] keys;
    private final Function<Meter.Id, T> tSupplier;
    private final ToDoubleFunction<T> dGetter;
    private final MeterRegistry registry;
    private final ConcurrentMap<Meter.Id, Object> gauges;

    public Gauges(ConcurrentMap<Meter.Id, Object> gauges, String name, String description, Supplier<T> tSupplier, ToDoubleFunction<T> dGetter, MeterRegistry registry, Label ... keys) {
        this.gauges = gauges;
        this.name = name;
        this.description = description;
        this.tSupplier = id -> tSupplier.get();
        this.dGetter = dGetter;
        this.registry = registry;
        this.keys = keys;
    }

    public T get(String ... values) {
        return this.get((Iterable<Tag>)null, values);
    }

    public T get(Iterable<Tag> customTags, String ... values) {
        T candidate;
        Tags tags = TagsCache.getOrCreate(customTags, this.keys, values);
        ContextInternal context = (ContextInternal)Vertx.currentContext();
        ValueSupplier<T> valueSupplier = this.getOrCreateValueSupplier(context);
        Gauge gauge = Gauge.builder((String)this.name, valueSupplier).description(this.description).tags((Iterable)tags).strongReference(true).register(this.registry);
        Meter.Id meterId = gauge.getId();
        Object res = this.gauges.get(meterId);
        if (res == null && (res = this.gauges.putIfAbsent(meterId, candidate = this.tSupplier.apply(meterId))) == null) {
            res = candidate;
            valueSupplier.id = meterId;
            return (T)res;
        }
        this.recycleValueSupplier(context, valueSupplier);
        return (T)res;
    }

    private ValueSupplier<T> getOrCreateValueSupplier(ContextInternal context) {
        ValueSupplier<T> res;
        if (context == null || (res = (ValueSupplier<T>)context.contextData().get(VALUE_SUPPLIER)) == null) {
            res = new ValueSupplier<T>(this.gauges, this.dGetter);
        }
        return res;
    }

    private void recycleValueSupplier(ContextInternal context, ValueSupplier<T> valueSupplier) {
        if (context != null) {
            context.contextData().put(VALUE_SUPPLIER, valueSupplier);
        }
    }

    private static class ValueSupplier<G>
    implements Supplier<Number> {
        final ConcurrentMap<Meter.Id, Object> gauges;
        final ToDoubleFunction<G> toDoubleFunc;
        volatile Meter.Id id;

        ValueSupplier(ConcurrentMap<Meter.Id, Object> gauges, ToDoubleFunction<G> toDoubleFunc) {
            this.gauges = gauges;
            this.toDoubleFunc = toDoubleFunc;
        }

        @Override
        public Number get() {
            Object o;
            Meter.Id key = this.id;
            if (key != null && (o = this.gauges.get(key)) != null) {
                return this.toDoubleFunc.applyAsDouble(o);
            }
            return 0.0;
        }
    }
}

