/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.impl.VertxMetricsImpl;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MicrometerMetricsFactory
implements VertxMetricsFactory {
    private static final Map<MeterRegistry, ConcurrentHashMap<Meter.Id, Object>> tables = new WeakHashMap<MeterRegistry, ConcurrentHashMap<Meter.Id, Object>>(1);
    private final MeterRegistry micrometerRegistry;

    public MicrometerMetricsFactory() {
        this(null);
    }

    public MicrometerMetricsFactory(MeterRegistry micrometerRegistry) {
        this.micrometerRegistry = micrometerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VertxMetrics metrics(VertxOptions vertxOptions) {
        ConcurrentHashMap gaugesTable;
        MetricsOptions metricsOptions = vertxOptions.getMetricsOptions();
        MicrometerMetricsOptions options = metricsOptions instanceof MicrometerMetricsOptions ? (MicrometerMetricsOptions)metricsOptions : new MicrometerMetricsOptions(metricsOptions.toJson());
        MeterRegistry meterRegistry = this.micrometerRegistry;
        if (meterRegistry == null) {
            meterRegistry = options.getMicrometerRegistry();
        }
        BackendRegistry backendRegistry = BackendRegistries.setupBackend(options, meterRegistry);
        Map<MeterRegistry, ConcurrentHashMap<Meter.Id, Object>> map = tables;
        synchronized (map) {
            gaugesTable = tables.computeIfAbsent(backendRegistry.getMeterRegistry(), mr -> new ConcurrentHashMap());
        }
        VertxMetricsImpl metrics = new VertxMetricsImpl(options, backendRegistry, (ConcurrentMap<Meter.Id, Object>)gaugesTable);
        metrics.init();
        if (options.isJvmMetricsEnabled()) {
            new ClassLoaderMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmMemoryMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmGcMetrics().bindTo(backendRegistry.getMeterRegistry());
            new ProcessorMetrics().bindTo(backendRegistry.getMeterRegistry());
            new JvmThreadMetrics().bindTo(backendRegistry.getMeterRegistry());
        }
        return metrics;
    }

    public MetricsOptions newOptions(MetricsOptions options) {
        if (options instanceof MicrometerMetricsOptions) {
            return new MicrometerMetricsOptions((MicrometerMetricsOptions)options);
        }
        return super.newOptions(options);
    }

    public MetricsOptions newOptions() {
        return this.newOptions((JsonObject)null);
    }

    public MetricsOptions newOptions(JsonObject jsonObject) {
        return jsonObject == null ? new MicrometerMetricsOptions() : new MicrometerMetricsOptions(jsonObject);
    }
}

