/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.backends;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.Match;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.backends.InfluxDbBackendRegistry;
import io.vertx.micrometer.backends.JmxBackendRegistry;
import io.vertx.micrometer.backends.NoopBackendRegistry;
import io.vertx.micrometer.backends.PrometheusBackendRegistry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class BackendRegistries {
    private static final Map<String, BackendRegistry> REGISTRIES = new ConcurrentHashMap<String, BackendRegistry>();

    private BackendRegistries() {
    }

    public static BackendRegistry setupBackend(MicrometerMetricsOptions options, MeterRegistry meterRegistry) {
        return REGISTRIES.computeIfAbsent(options.getRegistryName(), k -> {
            BackendRegistry reg = meterRegistry != null ? (options.getPrometheusOptions() != null && meterRegistry instanceof PrometheusMeterRegistry ? new PrometheusBackendRegistry(options.getPrometheusOptions(), (PrometheusMeterRegistry)meterRegistry) : () -> meterRegistry) : (options.getInfluxDbOptions() != null && options.getInfluxDbOptions().isEnabled() ? new InfluxDbBackendRegistry(options.getInfluxDbOptions()) : (options.getPrometheusOptions() != null && options.getPrometheusOptions().isEnabled() ? new PrometheusBackendRegistry(options.getPrometheusOptions()) : (options.getJmxMetricsOptions() != null && options.getJmxMetricsOptions().isEnabled() ? new JmxBackendRegistry(options.getJmxMetricsOptions()) : NoopBackendRegistry.INSTANCE)));
            BackendRegistries.registerMatchers(reg.getMeterRegistry(), options.getLabels(), options.getLabelMatches());
            return reg;
        });
    }

    public static MeterRegistry getDefaultNow() {
        return BackendRegistries.getNow("default");
    }

    public static MeterRegistry getNow(String registryName) {
        BackendRegistry backendRegistry = REGISTRIES.get(registryName);
        if (backendRegistry != null) {
            return backendRegistry.getMeterRegistry();
        }
        return null;
    }

    public static void stop(String registryName) {
        BackendRegistry reg = REGISTRIES.remove(registryName);
        if (reg != null) {
            reg.close();
        }
    }

    public static void registerMatchers(MeterRegistry registry, Set<Label> enabledLabels, List<Match> matches) {
        Set<String> ignored = EnumSet.complementOf(EnumSet.copyOf(enabledLabels)).stream().map(Label::toString).collect(Collectors.toSet());
        if (!ignored.isEmpty()) {
            registry.config().meterFilter(BackendRegistries.ignoreTags(ignored));
        }
        matches.forEach(m -> {
            switch (m.getType()) {
                case EQUALS: {
                    if (m.getAlias() == null) {
                        registry.config().meterFilter(MeterFilter.deny(id -> {
                            if (m.getDomain() != null && !id.getName().startsWith(m.getDomain().getPrefix())) {
                                return false;
                            }
                            String tagValue = id.getTag(m.getLabel());
                            return !m.getValue().equals(tagValue);
                        }));
                        break;
                    }
                    registry.config().meterFilter(BackendRegistries.replaceTagValues(m.getDomain(), m.getLabel(), val -> {
                        if (m.getValue().equals(val)) {
                            return m.getAlias();
                        }
                        return val;
                    }));
                    break;
                }
                case REGEX: {
                    Pattern pattern = Pattern.compile(m.getValue());
                    if (m.getAlias() == null) {
                        registry.config().meterFilter(MeterFilter.accept(id -> {
                            if (m.getDomain() != null && !id.getName().startsWith(m.getDomain().getPrefix())) {
                                return true;
                            }
                            String tagValue = id.getTag(m.getLabel());
                            if (tagValue == null) {
                                return false;
                            }
                            return pattern.matcher(tagValue).matches();
                        }));
                        break;
                    }
                    registry.config().meterFilter(BackendRegistries.replaceTagValues(m.getDomain(), m.getLabel(), val -> {
                        if (pattern.matcher((CharSequence)val).matches()) {
                            return m.getAlias();
                        }
                        return val;
                    }));
                }
            }
        });
    }

    private static MeterFilter ignoreTags(final Set<String> ignored) {
        return new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                ArrayList<Tag> tags = new ArrayList<Tag>();
                int count = 0;
                for (Tag tag : id.getTagsAsIterable()) {
                    if (!ignored.contains(tag.getKey())) {
                        tags.add(tag);
                    }
                    ++count;
                }
                return tags.size() == count ? id : id.replaceTags(tags);
            }
        };
    }

    private static MeterFilter replaceTagValues(final MetricsDomain domain, final String tagKey, final Function<String, String> replacement) {
        return new MeterFilter(){

            public Meter.Id map(Meter.Id id) {
                if (domain != null && !id.getName().startsWith(domain.getPrefix())) {
                    return id;
                }
                return MeterFilter.replaceTagValues((String)tagKey, (Function)replacement, (String[])new String[0]).map(id);
            }
        };
    }
}

