/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.metrics.impl.DummyVertxMetrics;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.MicrometerMetricsOptions;
import io.vertx.micrometer.backends.BackendRegistries;
import io.vertx.micrometer.backends.BackendRegistry;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.VertxClientMetrics;
import io.vertx.micrometer.impl.VertxDatagramSocketMetrics;
import io.vertx.micrometer.impl.VertxEventBusMetrics;
import io.vertx.micrometer.impl.VertxHttpClientMetrics;
import io.vertx.micrometer.impl.VertxHttpServerMetrics;
import io.vertx.micrometer.impl.VertxNetClientMetrics;
import io.vertx.micrometer.impl.VertxNetServerMetrics;
import io.vertx.micrometer.impl.VertxPoolMetrics;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VertxMetricsImpl
extends AbstractMetrics
implements VertxMetrics {
    private final BackendRegistry backendRegistry;
    private final String registryName;
    private final MetricsNaming names;
    private final EventBusMetrics eventBusMetrics;
    private final DatagramSocketMetrics datagramSocketMetrics;
    private final VertxNetClientMetrics netClientMetrics;
    private final VertxNetServerMetrics netServerMetrics;
    private final VertxHttpClientMetrics httpClientMetrics;
    private final VertxHttpServerMetrics httpServerMetrics;
    private final VertxPoolMetrics poolMetrics;
    private final Map<String, VertxClientMetrics> mapClientMetrics = new ConcurrentHashMap<String, VertxClientMetrics>();
    private final Set<String> disabledCategories = new HashSet<String>();

    public VertxMetricsImpl(MicrometerMetricsOptions options, BackendRegistry backendRegistry, ConcurrentMap<Meter.Id, Object> gaugesTable) {
        super(backendRegistry.getMeterRegistry(), gaugesTable);
        this.backendRegistry = backendRegistry;
        this.registryName = options.getRegistryName();
        MeterRegistry registry = backendRegistry.getMeterRegistry();
        if (options.getDisabledMetricsCategories() != null) {
            this.disabledCategories.addAll(options.getDisabledMetricsCategories());
        }
        this.names = options.getMetricsNaming();
        this.eventBusMetrics = options.isMetricsCategoryDisabled(MetricsDomain.EVENT_BUS) ? null : new VertxEventBusMetrics(registry, this.names, gaugesTable);
        this.datagramSocketMetrics = options.isMetricsCategoryDisabled(MetricsDomain.DATAGRAM_SOCKET) ? null : new VertxDatagramSocketMetrics(registry, this.names, gaugesTable);
        this.netClientMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NET_CLIENT) ? null : new VertxNetClientMetrics(registry, this.names, gaugesTable);
        this.netServerMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NET_SERVER) ? null : new VertxNetServerMetrics(registry, this.names, gaugesTable);
        this.httpClientMetrics = options.isMetricsCategoryDisabled(MetricsDomain.HTTP_CLIENT) ? null : new VertxHttpClientMetrics(registry, this.names, options.getClientRequestTagsProvider(), gaugesTable);
        this.httpServerMetrics = options.isMetricsCategoryDisabled(MetricsDomain.HTTP_SERVER) ? null : new VertxHttpServerMetrics(registry, this.names, options.getServerRequestTagsProvider(), gaugesTable);
        this.poolMetrics = options.isMetricsCategoryDisabled(MetricsDomain.NAMED_POOLS) ? null : new VertxPoolMetrics(registry, this.names, gaugesTable);
    }

    public void init() {
        this.backendRegistry.init();
    }

    public EventBusMetrics createEventBusMetrics() {
        if (this.eventBusMetrics != null) {
            return this.eventBusMetrics;
        }
        return DummyVertxMetrics.DummyEventBusMetrics.INSTANCE;
    }

    public HttpServerMetrics<?, ?, ?> createHttpServerMetrics(HttpServerOptions httpClientOptions, SocketAddress socketAddress) {
        if (this.httpServerMetrics != null) {
            return this.httpServerMetrics.forAddress(socketAddress);
        }
        return DummyVertxMetrics.DummyHttpServerMetrics.INSTANCE;
    }

    public HttpClientMetrics<?, ?, ?, ?> createHttpClientMetrics(HttpClientOptions httpClientOptions) {
        if (this.httpClientMetrics != null) {
            return this.httpClientMetrics.forAddress(httpClientOptions.getLocalAddress());
        }
        return DummyVertxMetrics.DummyHttpClientMetrics.INSTANCE;
    }

    public TCPMetrics<?> createNetServerMetrics(NetServerOptions netServerOptions, SocketAddress socketAddress) {
        if (this.netServerMetrics != null) {
            return this.netServerMetrics.forAddress(socketAddress);
        }
        return DummyVertxMetrics.DummyTCPMetrics.INSTANCE;
    }

    public TCPMetrics<?> createNetClientMetrics(NetClientOptions netClientOptions) {
        if (this.netClientMetrics != null) {
            return this.netClientMetrics.forAddress(netClientOptions.getLocalAddress());
        }
        return DummyVertxMetrics.DummyTCPMetrics.INSTANCE;
    }

    public DatagramSocketMetrics createDatagramSocketMetrics(DatagramSocketOptions options) {
        if (this.datagramSocketMetrics != null) {
            return this.datagramSocketMetrics;
        }
        return DummyVertxMetrics.DummyDatagramMetrics.INSTANCE;
    }

    public PoolMetrics<?> createPoolMetrics(String poolType, String poolName, int maxPoolSize) {
        if (this.poolMetrics != null) {
            return this.poolMetrics.forInstance(poolType, poolName, maxPoolSize);
        }
        return DummyVertxMetrics.DummyWorkerPoolMetrics.INSTANCE;
    }

    public ClientMetrics<?, ?, ?, ?> createClientMetrics(SocketAddress remoteAddress, String type, String namespace) {
        if (this.disabledCategories.contains(type)) {
            return DummyVertxMetrics.DummyClientMetrics.INSTANCE;
        }
        VertxClientMetrics clientMetrics = this.mapClientMetrics.computeIfAbsent(type, t -> new VertxClientMetrics(this.registry, type, this.names, this.gaugesTable));
        return clientMetrics.forInstance(remoteAddress, namespace);
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    public void close() {
        BackendRegistries.stop(this.registryName);
    }
}

