/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.tags.Labels;
import java.util.concurrent.atomic.LongAdder;

class VertxClientMetrics
extends AbstractMetrics
implements ClientMetrics<Timer.Sample, Object, Object> {
    final Timer processingTime;
    final LongAdder processingPending;
    final Counter resetCount;

    VertxClientMetrics(AbstractMetrics parent, SocketAddress remoteAddress, String type, String namespace) {
        super(parent, type);
        Tags tags = Tags.empty();
        if (this.enabledLabels.contains((Object)Label.REMOTE)) {
            tags = tags.and(Label.REMOTE.toString(), Labels.address(remoteAddress));
        }
        if (this.enabledLabels.contains((Object)Label.NAMESPACE)) {
            tags = tags.and(Label.NAMESPACE.toString(), namespace == null ? "" : namespace);
        }
        this.processingTime = Timer.builder((String)this.names.getClientProcessingTime()).description("Processing time, from request start to response end").tags((Iterable)tags).register(this.registry);
        this.processingPending = this.longGaugeBuilder(this.names.getClientProcessingPending(), LongAdder::doubleValue).description("Number of elements being processed").tags((Iterable<Tag>)tags).register(this.registry);
        this.resetCount = Counter.builder((String)this.names.getClientResetsCount()).description("Total number of resets").tags((Iterable)tags).register(this.registry);
    }

    public Timer.Sample requestBegin(String uri, Object request) {
        this.processingPending.increment();
        return Timer.start();
    }

    public void requestEnd(Timer.Sample requestMetric) {
    }

    public void responseBegin(Timer.Sample requestMetric, Object response) {
    }

    public void requestReset(Timer.Sample requestMetric) {
        this.processingPending.decrement();
        requestMetric.stop(this.processingTime);
        this.resetCount.increment();
    }

    public void responseEnd(Timer.Sample requestMetric) {
        this.processingPending.decrement();
        requestMetric.stop(this.processingTime);
    }
}

