/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.HttpUtils;
import io.vertx.micrometer.impl.VertxNetServerMetrics;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;

class VertxHttpServerMetrics
extends VertxNetServerMetrics
implements HttpServerMetrics<RequestMetric, LongAdder, VertxNetServerMetrics.NetServerSocketMetric> {
    private final Function<HttpRequest, Iterable<Tag>> customTagsProvider;
    private final Meter.MeterProvider<Counter> requestResetCount;
    private final Meter.MeterProvider<DistributionSummary> requestBytes;
    private final Meter.MeterProvider<Counter> httpRequestsCount;
    private final Meter.MeterProvider<Timer> httpResponseTime;
    private final Meter.MeterProvider<DistributionSummary> httpResponseBytes;

    VertxHttpServerMetrics(AbstractMetrics parent, Function<HttpRequest, Iterable<Tag>> customTagsProvider, SocketAddress localAddress) {
        super(parent, MetricsDomain.HTTP_SERVER, localAddress);
        this.customTagsProvider = customTagsProvider;
        this.requestResetCount = Counter.builder((String)this.names.getHttpRequestResetsCount()).description("Number of request resets").withRegistry(this.registry);
        this.requestBytes = DistributionSummary.builder((String)this.names.getHttpRequestBytes()).description("Size of requests in bytes").withRegistry(this.registry);
        this.httpRequestsCount = Counter.builder((String)this.names.getHttpRequestsCount()).description("Number of processed requests").withRegistry(this.registry);
        this.httpResponseTime = Timer.builder((String)this.names.getHttpResponseTime()).description("Request processing time").withRegistry(this.registry);
        this.httpResponseBytes = DistributionSummary.builder((String)this.names.getHttpResponseBytes()).description("Size of responses in bytes").withRegistry(this.registry);
    }

    public RequestMetric requestBegin(VertxNetServerMetrics.NetServerSocketMetric socketMetric, HttpRequest request) {
        Tags tags = socketMetric.tags;
        if (this.enabledLabels.contains((Object)Label.HTTP_PATH)) {
            tags = tags.and(Label.HTTP_PATH.toString(), HttpUtils.parsePath(request.uri()));
        }
        if (this.enabledLabels.contains((Object)Label.HTTP_METHOD)) {
            tags = tags.and(Label.HTTP_METHOD.toString(), request.method().toString());
        }
        if (this.customTagsProvider != null) {
            tags = tags.and(this.customTagsProvider.apply(request));
        }
        RequestMetric requestMetric = new RequestMetric(tags);
        requestMetric.requests.increment();
        return requestMetric;
    }

    public void requestReset(RequestMetric requestMetric) {
        ((Counter)this.requestResetCount.withTags((Iterable)requestMetric.tags)).increment();
        requestMetric.requests.decrement();
        requestMetric.requestReset();
    }

    public void requestEnd(RequestMetric requestMetric, HttpRequest request, long bytesRead) {
        ((DistributionSummary)this.requestBytes.withTags((Iterable)requestMetric.tags)).record((double)bytesRead);
        if (requestMetric.requestEnded()) {
            requestMetric.requests.decrement();
        }
    }

    public RequestMetric responsePushed(VertxNetServerMetrics.NetServerSocketMetric socketMetric, HttpMethod method, String uri, HttpResponse response) {
        Tags tags = socketMetric.tags;
        if (this.enabledLabels.contains((Object)Label.HTTP_PATH)) {
            tags.and(Label.HTTP_PATH.toString(), HttpUtils.parsePath(uri));
        }
        if (this.enabledLabels.contains((Object)Label.HTTP_METHOD)) {
            tags.and(Label.HTTP_METHOD.toString(), method.toString());
        }
        RequestMetric requestMetric = new RequestMetric(tags);
        requestMetric.requests.increment();
        return requestMetric;
    }

    public void responseEnd(RequestMetric requestMetric, HttpResponse response, long bytesWritten) {
        Tags responseTags = requestMetric.tags;
        if (this.enabledLabels.contains((Object)Label.HTTP_ROUTE)) {
            responseTags = responseTags.and(Label.HTTP_ROUTE.toString(), requestMetric.getRoute());
        }
        if (this.enabledLabels.contains((Object)Label.HTTP_CODE)) {
            responseTags = responseTags.and(Label.HTTP_CODE.toString(), String.valueOf(response.statusCode()));
        }
        ((Counter)this.httpRequestsCount.withTags((Iterable)responseTags)).increment();
        requestMetric.sample.stop((Timer)this.httpResponseTime.withTags((Iterable)responseTags));
        ((DistributionSummary)this.httpResponseBytes.withTags((Iterable)responseTags)).record((double)bytesWritten);
        if (requestMetric.responseEnded()) {
            requestMetric.requests.decrement();
        }
    }

    public LongAdder connected(VertxNetServerMetrics.NetServerSocketMetric socketMetric, RequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        LongAdder wsConnections = this.longGaugeBuilder(this.names.getHttpActiveWsConnections(), LongAdder::doubleValue).description("Number of websockets currently opened").tags((Iterable<Tag>)socketMetric.tags).register(this.registry);
        wsConnections.increment();
        return wsConnections;
    }

    public void disconnected(LongAdder wsConnections) {
        wsConnections.decrement();
    }

    public void requestRouted(RequestMetric requestMetric, String route) {
        requestMetric.addRoute(route);
    }

    class RequestMetric {
        final Tags tags;
        final LongAdder requests;
        final Timer.Sample sample;
        private Object routes;
        private int routesLength;
        private boolean responseEnded;
        private boolean requestEnded;
        private boolean reset;

        RequestMetric(Tags tags) {
            this.tags = tags;
            this.requests = VertxHttpServerMetrics.this.longGaugeBuilder(VertxHttpServerMetrics.this.names.getHttpActiveRequests(), LongAdder::doubleValue).description("Number of requests being processed").tags((Iterable<Tag>)tags).register(VertxHttpServerMetrics.this.registry);
            this.sample = Timer.start();
        }

        private void addRoute(String route) {
            if (route == null) {
                return;
            }
            this.routesLength += route.length();
            if (this.routes == null) {
                this.routes = route;
                return;
            }
            ++this.routesLength;
            if (this.routes instanceof List) {
                ((List)this.routes).add(route);
                return;
            }
            LinkedList<String> multipleRoutes = new LinkedList<String>();
            multipleRoutes.add((String)this.routes);
            multipleRoutes.add(route);
            this.routes = multipleRoutes;
        }

        private String getRoute() {
            if (this.routes == null) {
                return "";
            }
            if (this.routes instanceof String) {
                return (String)this.routes;
            }
            StringBuilder concatenation = new StringBuilder(this.routesLength);
            Iterator iterator = ((List)this.routes).iterator();
            concatenation.append((String)iterator.next());
            while (iterator.hasNext()) {
                concatenation.append('>').append((String)iterator.next());
            }
            this.routes = concatenation.toString();
            return (String)this.routes;
        }

        void requestReset() {
            this.reset = true;
        }

        boolean requestEnded() {
            this.requestEnded = true;
            return !this.reset && this.responseEnded;
        }

        boolean responseEnded() {
            this.responseEnded = true;
            return !this.reset && this.requestEnded;
        }
    }
}

