/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.tags.Labels;
import java.util.concurrent.atomic.LongAdder;

class VertxNetServerMetrics
extends AbstractMetrics
implements TCPMetrics<NetServerSocketMetric> {
    final Tags local;
    private final Meter.MeterProvider<Counter> netErrorCount;

    VertxNetServerMetrics(AbstractMetrics parent, SocketAddress localAddress) {
        this(parent, MetricsDomain.NET_SERVER, localAddress);
    }

    VertxNetServerMetrics(AbstractMetrics parent, MetricsDomain domain, SocketAddress localAddress) {
        super(parent, domain);
        this.local = this.enabledLabels.contains((Object)Label.LOCAL) ? Tags.of((String)Label.LOCAL.toString(), (String)Labels.address(localAddress)) : Tags.empty();
        this.netErrorCount = Counter.builder((String)this.names.getNetErrorCount()).description("Number of errors").withRegistry(this.registry);
    }

    public NetServerSocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        Tags tags = this.local;
        if (this.enabledLabels.contains((Object)Label.REMOTE)) {
            tags = tags.and(Label.REMOTE.toString(), Labels.address(remoteAddress, remoteName));
        }
        NetServerSocketMetric socketMetric = new NetServerSocketMetric(tags);
        socketMetric.connections.increment();
        return socketMetric;
    }

    public void disconnected(NetServerSocketMetric socketMetric, SocketAddress remoteAddress) {
        socketMetric.connections.decrement();
    }

    public void bytesRead(NetServerSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesReceived.increment((double)numberOfBytes);
    }

    public void bytesWritten(NetServerSocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesSent.increment((double)numberOfBytes);
    }

    public void exceptionOccurred(NetServerSocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
        Tags tags = socketMetric.tags;
        if (this.enabledLabels.contains((Object)Label.CLASS_NAME)) {
            tags = tags.and(Label.CLASS_NAME.toString(), t.getClass().getSimpleName());
        }
        ((Counter)this.netErrorCount.withTags((Iterable)tags)).increment();
    }

    class NetServerSocketMetric {
        final Tags tags;
        final LongAdder connections;
        final Counter bytesReceived;
        final Counter bytesSent;

        NetServerSocketMetric(Tags tags) {
            this.tags = tags;
            this.connections = VertxNetServerMetrics.this.longGaugeBuilder(VertxNetServerMetrics.this.names.getNetActiveConnections(), LongAdder::doubleValue).description("Number of opened connections to the server").tags((Iterable<Tag>)tags).register(VertxNetServerMetrics.this.registry);
            this.bytesReceived = Counter.builder((String)VertxNetServerMetrics.this.names.getNetBytesRead()).description("Number of bytes received by the server").tags((Iterable)tags).register(VertxNetServerMetrics.this.registry);
            this.bytesSent = Counter.builder((String)VertxNetServerMetrics.this.names.getNetBytesWritten()).description("Number of bytes sent by the server").tags((Iterable)tags).register(VertxNetServerMetrics.this.registry);
        }
    }
}

