/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.tags;

import io.micrometer.core.instrument.Tag;
import io.vertx.core.net.SocketAddress;
import io.vertx.micrometer.Label;

public final class Labels {
    private static final Tag LOCAL = Tag.of((String)Label.EB_SIDE.toString(), (String)"local");
    private static final Tag REMOTE = Tag.of((String)Label.EB_SIDE.toString(), (String)"remote");

    private Labels() {
    }

    public static String address(SocketAddress address) {
        return Labels.address(address, null);
    }

    public static String address(SocketAddress address, String nameOverride) {
        if (address == null) {
            return "?";
        }
        if (nameOverride == null) {
            return address.toString();
        }
        SocketAddress addrOverride = address.port() >= 0 ? SocketAddress.inetSocketAddress((int)address.port(), (String)nameOverride) : SocketAddress.domainSocketAddress((String)nameOverride);
        return addrOverride.toString();
    }

    public static Tag side(boolean local) {
        return local ? LOCAL : REMOTE;
    }
}

