/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.MetricsNaming;
import io.vertx.micrometer.impl.MicrometerMetrics;
import io.vertx.micrometer.impl.meters.LongGaugeBuilder;
import io.vertx.micrometer.impl.meters.LongGauges;
import java.util.EnumSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.ToDoubleFunction;

public abstract class AbstractMetrics
implements MicrometerMetrics {
    protected final MeterRegistry registry;
    protected final MetricsNaming names;
    private final String category;
    protected final EnumSet<Label> enabledLabels;
    private final LongGauges longGauges;

    AbstractMetrics(MeterRegistry registry, MetricsNaming names, LongGauges longGauges, EnumSet<Label> enabledLabels) {
        this.registry = registry;
        this.category = null;
        this.enabledLabels = enabledLabels;
        this.names = names;
        this.longGauges = longGauges;
    }

    AbstractMetrics(AbstractMetrics parent, MetricsDomain domain) {
        this(parent, domain == null ? null : domain.toCategory());
    }

    AbstractMetrics(AbstractMetrics parent, String category) {
        this.registry = parent.registry;
        this.enabledLabels = parent.enabledLabels;
        this.longGauges = parent.longGauges;
        this.category = category;
        this.names = parent.names.withBaseName(this.baseName());
    }

    @Override
    public MeterRegistry registry() {
        return this.registry;
    }

    @Override
    public final String baseName() {
        return this.category == null ? null : "vertx." + this.category + ".";
    }

    LongGaugeBuilder longGaugeBuilder(String name, ToDoubleFunction<LongAdder> func) {
        return this.longGauges.builder(name, func);
    }
}

