/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.tags.Labels;
import java.util.concurrent.atomic.LongAdder;

class VertxEventBusMetrics
extends AbstractMetrics
implements EventBusMetrics<HandlerMetric> {
    private final Meter.MeterProvider<Counter> ebPublished;
    private final Meter.MeterProvider<Counter> ebSent;
    private final Meter.MeterProvider<Counter> ebReceived;
    private final Meter.MeterProvider<Counter> ebDelivered;
    private final Meter.MeterProvider<DistributionSummary> ebBytesWritten;
    private final Meter.MeterProvider<DistributionSummary> ebBytesRead;
    private final Meter.MeterProvider<Counter> ebReplyFailures;

    VertxEventBusMetrics(AbstractMetrics parent) {
        super(parent, MetricsDomain.EVENT_BUS);
        this.ebPublished = Counter.builder((String)this.names.getEbPublished()).description("Number of messages published (publish / subscribe)").withRegistry(this.registry);
        this.ebSent = Counter.builder((String)this.names.getEbSent()).description("Number of messages sent (point-to-point)").withRegistry(this.registry);
        this.ebReceived = Counter.builder((String)this.names.getEbReceived()).description("Number of messages received").withRegistry(this.registry);
        this.ebDelivered = Counter.builder((String)this.names.getEbDelivered()).description("Number of messages delivered to handlers").withRegistry(this.registry);
        this.ebBytesWritten = DistributionSummary.builder((String)this.names.getEbBytesWritten()).description("Number of bytes sent while sending messages to event bus cluster peers").withRegistry(this.registry);
        this.ebBytesRead = DistributionSummary.builder((String)this.names.getEbBytesRead()).description("Number of bytes received while reading messages from event bus cluster peers").withRegistry(this.registry);
        this.ebReplyFailures = Counter.builder((String)this.names.getEbReplyFailures()).description("Number of message reply failures").withRegistry(this.registry);
    }

    private static boolean isNotInternal(String address) {
        return !address.startsWith("__vertx.");
    }

    public HandlerMetric handlerRegistered(String address) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            HandlerMetric handlerMetric = new HandlerMetric(address);
            handlerMetric.handlers.increment();
            return handlerMetric;
        }
        return null;
    }

    public void handlerUnregistered(HandlerMetric handlerMetric) {
        if (handlerMetric != null) {
            handlerMetric.handlers.decrement();
        }
    }

    public void messageDelivered(HandlerMetric handlerMetric, boolean local) {
        if (handlerMetric != null) {
            if (local) {
                handlerMetric.ebPendingLocal.decrement();
                handlerMetric.ebProcessedLocal.increment();
            } else {
                handlerMetric.ebPendingRemote.decrement();
                handlerMetric.ebProcessedRemote.increment();
            }
        }
    }

    public void discardMessage(HandlerMetric handlerMetric, boolean local, Message<?> msg) {
        if (handlerMetric != null) {
            if (local) {
                handlerMetric.ebPendingLocal.decrement();
                handlerMetric.ebDiscardedLocal.increment();
            } else {
                handlerMetric.ebPendingRemote.decrement();
                handlerMetric.ebDiscardedRemote.increment();
            }
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            Tags tags = this.addressAndSide(address, local);
            if (publish) {
                ((Counter)this.ebPublished.withTags((Iterable)tags)).increment();
            } else {
                ((Counter)this.ebSent.withTags((Iterable)tags)).increment();
            }
        }
    }

    private Tags addressAndSide(String address, boolean local) {
        Tags tags = Tags.empty();
        if (this.enabledLabels.contains((Object)Label.EB_ADDRESS)) {
            tags = tags.and(Label.EB_ADDRESS.toString(), address);
        }
        if (this.enabledLabels.contains((Object)Label.EB_SIDE)) {
            tags = tags.and(new Tag[]{Labels.side(local)});
        }
        return tags;
    }

    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            Tags tags = this.addressAndSide(address, local);
            ((Counter)this.ebReceived.withTags((Iterable)tags)).increment();
            if (handlers > 0) {
                this.longGaugeBuilder(this.names.getEbPending(), LongAdder::doubleValue).description("Number of messages not processed yet").tags((Iterable<Tag>)tags).register(this.registry).add(handlers);
                ((Counter)this.ebDelivered.withTags((Iterable)tags)).increment();
            }
        }
    }

    public void messageWritten(String address, int numberOfBytes) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            Tags tags = this.address(address);
            ((DistributionSummary)this.ebBytesWritten.withTags((Iterable)tags)).record((double)numberOfBytes);
        }
    }

    private Tags address(String address) {
        Tags tags = Tags.empty();
        if (this.enabledLabels.contains((Object)Label.EB_ADDRESS)) {
            tags = tags.and(Label.EB_ADDRESS.toString(), address);
        }
        return tags;
    }

    public void messageRead(String address, int numberOfBytes) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            Tags tags = this.address(address);
            ((DistributionSummary)this.ebBytesRead.withTags((Iterable)tags)).record((double)numberOfBytes);
        }
    }

    public void replyFailure(String address, ReplyFailure failure) {
        if (VertxEventBusMetrics.isNotInternal(address)) {
            Tags tags = this.addressAndFailure(address, failure);
            ((Counter)this.ebReplyFailures.withTags((Iterable)tags)).increment();
        }
    }

    private Tags addressAndFailure(String address, ReplyFailure replyFailure) {
        Tags tags = Tags.empty();
        if (this.enabledLabels.contains((Object)Label.EB_ADDRESS)) {
            tags = tags.and(Label.EB_ADDRESS.toString(), address);
        }
        if (this.enabledLabels.contains((Object)Label.EB_FAILURE)) {
            tags = tags.and(Label.EB_FAILURE.toString(), replyFailure.name());
        }
        return tags;
    }

    class HandlerMetric {
        final LongAdder handlers;
        final LongAdder ebPendingLocal;
        final Counter ebProcessedLocal;
        final LongAdder ebPendingRemote;
        final Counter ebProcessedRemote;
        final Counter ebDiscardedLocal;
        final Counter ebDiscardedRemote;

        HandlerMetric(String address) {
            Tags tags = Tags.empty();
            if (VertxEventBusMetrics.this.enabledLabels.contains((Object)Label.EB_ADDRESS)) {
                tags = tags.and(Label.EB_ADDRESS.toString(), address);
            }
            this.handlers = VertxEventBusMetrics.this.longGaugeBuilder(VertxEventBusMetrics.this.names.getEbHandlers(), LongAdder::doubleValue).description("Number of event bus handlers in use").tags((Iterable<Tag>)tags).register(VertxEventBusMetrics.this.registry);
            Tags localTags = tags;
            Tags remoteTags = tags;
            if (VertxEventBusMetrics.this.enabledLabels.contains((Object)Label.EB_SIDE)) {
                localTags = tags.and(new Tag[]{Labels.side(true)});
                remoteTags = tags.and(new Tag[]{Labels.side(false)});
            }
            this.ebPendingLocal = VertxEventBusMetrics.this.longGaugeBuilder(VertxEventBusMetrics.this.names.getEbPending(), LongAdder::doubleValue).description("Number of messages not processed yet").tags((Iterable<Tag>)localTags).register(VertxEventBusMetrics.this.registry);
            this.ebProcessedLocal = Counter.builder((String)VertxEventBusMetrics.this.names.getEbProcessed()).description("Number of processed messages").tags((Iterable)localTags).register(VertxEventBusMetrics.this.registry);
            this.ebDiscardedLocal = Counter.builder((String)VertxEventBusMetrics.this.names.getEbDiscarded()).description("Number of discarded messages").tags((Iterable)localTags).register(VertxEventBusMetrics.this.registry);
            this.ebPendingRemote = VertxEventBusMetrics.this.longGaugeBuilder(VertxEventBusMetrics.this.names.getEbPending(), LongAdder::doubleValue).description("Number of messages not processed yet").tags((Iterable<Tag>)remoteTags).register(VertxEventBusMetrics.this.registry);
            this.ebProcessedRemote = Counter.builder((String)VertxEventBusMetrics.this.names.getEbProcessed()).description("Number of processed messages").tags((Iterable)remoteTags).register(VertxEventBusMetrics.this.registry);
            this.ebDiscardedRemote = Counter.builder((String)VertxEventBusMetrics.this.names.getEbDiscarded()).description("Number of discarded messages").tags((Iterable)remoteTags).register(VertxEventBusMetrics.this.registry);
        }
    }
}

