/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer;

import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.micrometer.VertxPrometheusOptions;
import java.util.Map;

public class VertxPrometheusOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, VertxPrometheusOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "startEmbeddedServer": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setStartEmbeddedServer((Boolean)member.getValue());
                    break;
                }
                case "embeddedServerOptions": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setEmbeddedServerOptions(new HttpServerOptions((JsonObject)member.getValue()));
                    break;
                }
                case "embeddedServerEndpoint": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setEmbeddedServerEndpoint((String)member.getValue());
                    break;
                }
                case "publishQuantiles": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setPublishQuantiles((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(VertxPrometheusOptions obj, JsonObject json) {
        VertxPrometheusOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(VertxPrometheusOptions obj, Map<String, Object> json) {
        json.put("enabled", obj.isEnabled());
        json.put("startEmbeddedServer", obj.isStartEmbeddedServer());
        if (obj.getEmbeddedServerOptions() != null) {
            json.put("embeddedServerOptions", obj.getEmbeddedServerOptions().toJson());
        }
        if (obj.getEmbeddedServerEndpoint() != null) {
            json.put("embeddedServerEndpoint", obj.getEmbeddedServerEndpoint());
        }
        json.put("publishQuantiles", obj.isPublishQuantiles());
    }
}

