/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl.meters;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.vertx.micrometer.impl.meters.LongAdderSupplier;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public class LongGaugeBuilder {
    private final LongAdderSupplier supplier;
    private final Gauge.Builder<Supplier<Number>> builder;
    private final ConcurrentMap<Meter.Id, LongAdder> longGauges;

    LongGaugeBuilder(String name, ConcurrentMap<Meter.Id, LongAdder> longGauges, ToDoubleFunction<LongAdder> func) {
        this.supplier = new LongAdderSupplier(longGauges, func);
        this.builder = Gauge.builder((String)name, (Supplier)this.supplier);
        this.longGauges = longGauges;
    }

    public LongGaugeBuilder description(String description) {
        this.builder.description(description);
        return this;
    }

    public LongGaugeBuilder tags(Iterable<Tag> tags) {
        this.builder.tags(tags);
        return this;
    }

    public LongAdder register(MeterRegistry registry) {
        Meter.Id meterId = this.builder.register(registry).getId();
        this.supplier.setId(meterId);
        return this.longGauges.computeIfAbsent(meterId, id -> new LongAdder());
    }
}

