/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.micrometer.impl;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tags;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.micrometer.Label;
import io.vertx.micrometer.MetricsDomain;
import io.vertx.micrometer.impl.AbstractMetrics;
import io.vertx.micrometer.impl.tags.Labels;

class VertxDatagramSocketMetrics
extends AbstractMetrics
implements DatagramSocketMetrics {
    private final DistributionSummary bytesWritten;
    private final Meter.MeterProvider<Counter> errorCount;
    private volatile DistributionSummary bytesRead;

    VertxDatagramSocketMetrics(AbstractMetrics parent) {
        super(parent, MetricsDomain.DATAGRAM_SOCKET);
        this.bytesWritten = DistributionSummary.builder((String)this.names.getDatagramBytesWritten()).description("Total number of datagram bytes sent").register(this.registry);
        this.errorCount = Counter.builder((String)this.names.getDatagramErrorCount()).description("Total number of datagram errors").withRegistry(this.registry);
    }

    public void listening(String localName, SocketAddress localAddress) {
        Tags tags = this.enabledLabels.contains((Object)Label.LOCAL) ? Tags.of((String)Label.LOCAL.toString(), (String)Labels.address(localAddress, localName)) : Tags.empty();
        this.bytesRead = DistributionSummary.builder((String)this.names.getDatagramBytesRead()).description("Total number of datagram bytes received").tags((Iterable)tags).register(this.registry);
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        if (this.bytesRead != null) {
            this.bytesRead.record((double)numberOfBytes);
        }
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesWritten.record((double)numberOfBytes);
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        Tags tags = this.enabledLabels.contains((Object)Label.CLASS_NAME) ? Tags.of((String)Label.CLASS_NAME.toString(), (String)t.getClass().getSimpleName()) : Tags.empty();
        ((Counter)this.errorCount.withTags((Iterable)tags)).increment();
    }
}

