/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

@DataObject
public class IndexOptions {
    public static final boolean DEFAULT_BACKGROUD = false;
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_SPARSE = false;
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private JsonObject weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Double bucketSize;
    private JsonObject storageEngine;
    private JsonObject partialFilterExpression;

    public IndexOptions() {
        this.background = false;
        this.unique = false;
        this.sparse = false;
    }

    public IndexOptions(IndexOptions options) {
        this.background = options.background;
        this.unique = options.unique;
        this.name = options.name;
        this.sparse = options.sparse;
        this.expireAfterSeconds = options.expireAfterSeconds;
        this.version = options.version;
        this.weights = options.weights;
        this.defaultLanguage = options.defaultLanguage;
        this.languageOverride = options.languageOverride;
        this.textVersion = options.textVersion;
        this.sphereVersion = options.sphereVersion;
        this.bits = options.bits;
        this.min = options.min;
        this.max = options.max;
        this.bucketSize = options.bucketSize;
        this.storageEngine = options.storageEngine;
        this.partialFilterExpression = options.partialFilterExpression;
    }

    public IndexOptions(JsonObject options) {
        this.background = options.getBoolean("background", Boolean.valueOf(false));
        this.unique = options.getBoolean("unique", Boolean.valueOf(false));
        this.name = options.getString("name");
        this.sparse = options.getBoolean("sparse", Boolean.valueOf(false));
        this.expireAfterSeconds = options.getLong("expireAfterSeconds");
        this.version = options.getInteger("version");
        this.weights = options.getJsonObject("weights");
        this.defaultLanguage = options.getString("defaultLanguage");
        this.languageOverride = options.getString("languageOverride");
        this.textVersion = options.getInteger("textVersion");
        this.sphereVersion = options.getInteger("sphereVersion");
        this.bits = options.getInteger("bits");
        this.min = options.getDouble("min");
        this.max = options.getDouble("max");
        this.bucketSize = options.getDouble("bucketSize");
        this.storageEngine = options.getJsonObject("storageEngine");
        this.partialFilterExpression = options.getJsonObject("partialFilterExpression");
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("background", Boolean.valueOf(this.background));
        json.put("unique", Boolean.valueOf(this.unique));
        json.put("sparse", Boolean.valueOf(this.sparse));
        if (this.name != null) {
            json.put("name", this.name);
        }
        if (this.expireAfterSeconds != null) {
            json.put("expireAfterSeconds", this.expireAfterSeconds);
        }
        if (this.version != null) {
            json.put("version", this.version);
        }
        if (this.weights != null) {
            json.put("weights", this.weights);
        }
        if (this.defaultLanguage != null) {
            json.put("defaultLanguage", this.defaultLanguage);
        }
        if (this.languageOverride != null) {
            json.put("languageOverride", this.languageOverride);
        }
        if (this.textVersion != null) {
            json.put("textVersion", this.textVersion);
        }
        if (this.sphereVersion != null) {
            json.put("sphereVersion", this.sphereVersion);
        }
        if (this.bits != null) {
            json.put("bits", this.bits);
        }
        if (this.min != null) {
            json.put("min", this.min);
        }
        if (this.max != null) {
            json.put("max", this.max);
        }
        if (this.bucketSize != null) {
            json.put("bucketSize", this.bucketSize);
        }
        if (this.storageEngine != null) {
            json.put("storageEngine", this.storageEngine);
        }
        if (this.partialFilterExpression != null) {
            json.put("partialFilterExpression", this.partialFilterExpression);
        }
        return json;
    }

    public boolean isBackground() {
        return this.background;
    }

    public IndexOptions background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexOptions unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexOptions sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexOptions expireAfter(Long expireAfter, TimeUnit timeUnit) {
        this.expireAfterSeconds = expireAfter == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(expireAfter, timeUnit));
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public IndexOptions version(Integer version) {
        this.version = version;
        return this;
    }

    public JsonObject getWeights() {
        return this.weights;
    }

    public IndexOptions weights(JsonObject weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexOptions defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexOptions languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexOptions textVersion(Integer textVersion) {
        this.textVersion = textVersion;
        return this;
    }

    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexOptions sphereVersion(Integer sphereVersion) {
        this.sphereVersion = sphereVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public IndexOptions bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public IndexOptions min(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public IndexOptions max(Double max) {
        this.max = max;
        return this;
    }

    public Double getBucketSize() {
        return this.bucketSize;
    }

    public IndexOptions bucketSize(Double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }

    public JsonObject getStorageEngine() {
        return this.storageEngine;
    }

    public IndexOptions storageEngine(JsonObject storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public JsonObject getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexOptions partialFilterExpression(JsonObject partialFilterExpression) {
        this.partialFilterExpression = partialFilterExpression;
        return this;
    }
}

