/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.MongoClientImpl;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface MongoClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public static MongoClient createNonShared(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config, String dataSourceName) {
        return new MongoClientImpl(vertx, config, dataSourceName);
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, DEFAULT_POOL_NAME);
    }

    @Fluent
    public MongoClient save(String var1, JsonObject var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public MongoClient saveWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<String>> var4);

    @Fluent
    public MongoClient insert(String var1, JsonObject var2, Handler<AsyncResult<String>> var3);

    @Fluent
    public MongoClient insertWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<String>> var4);

    @Deprecated
    @Fluent
    public MongoClient update(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient updateCollection(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<MongoClientUpdateResult>> var4);

    @Deprecated
    @Fluent
    public MongoClient updateWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public MongoClient updateCollectionWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<MongoClientUpdateResult>> var5);

    @Deprecated
    @Fluent
    public MongoClient replace(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient replaceDocuments(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<MongoClientUpdateResult>> var4);

    @Deprecated
    @Fluent
    public MongoClient replaceWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<Void>> var5);

    @Fluent
    public MongoClient replaceDocumentsWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<MongoClientUpdateResult>> var5);

    @Fluent
    public MongoClient bulkWrite(String var1, List<BulkOperation> var2, Handler<AsyncResult<MongoClientBulkWriteResult>> var3);

    @Fluent
    public MongoClient bulkWriteWithOptions(String var1, List<BulkOperation> var2, BulkWriteOptions var3, Handler<AsyncResult<MongoClientBulkWriteResult>> var4);

    @Fluent
    public MongoClient find(String var1, JsonObject var2, Handler<AsyncResult<List<JsonObject>>> var3);

    public ReadStream<JsonObject> findBatch(String var1, JsonObject var2);

    @Fluent
    public MongoClient findWithOptions(String var1, JsonObject var2, FindOptions var3, Handler<AsyncResult<List<JsonObject>>> var4);

    public ReadStream<JsonObject> findBatchWithOptions(String var1, JsonObject var2, FindOptions var3);

    @Fluent
    public MongoClient findOne(String var1, JsonObject var2, @Nullable JsonObject var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public MongoClient findOneAndUpdate(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public MongoClient findOneAndUpdateWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5, Handler<AsyncResult<JsonObject>> var6);

    @Fluent
    public MongoClient findOneAndReplace(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public MongoClient findOneAndReplaceWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5, Handler<AsyncResult<JsonObject>> var6);

    @Fluent
    public MongoClient findOneAndDelete(String var1, JsonObject var2, Handler<AsyncResult<JsonObject>> var3);

    @Fluent
    public MongoClient findOneAndDeleteWithOptions(String var1, JsonObject var2, FindOptions var3, Handler<AsyncResult<JsonObject>> var4);

    @Fluent
    public MongoClient count(String var1, JsonObject var2, Handler<AsyncResult<Long>> var3);

    @Deprecated
    @Fluent
    public MongoClient remove(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient removeDocuments(String var1, JsonObject var2, Handler<AsyncResult<MongoClientDeleteResult>> var3);

    @Deprecated
    @Fluent
    public MongoClient removeWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient removeDocumentsWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<MongoClientDeleteResult>> var4);

    @Deprecated
    @Fluent
    public MongoClient removeOne(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient removeDocument(String var1, JsonObject var2, Handler<AsyncResult<MongoClientDeleteResult>> var3);

    @Deprecated
    @Fluent
    public MongoClient removeOneWithOptions(String var1, JsonObject var2, WriteOption var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient removeDocumentWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<MongoClientDeleteResult>> var4);

    @Fluent
    public MongoClient createCollection(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public MongoClient dropCollection(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MongoClient createIndex(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient createIndexWithOptions(String var1, JsonObject var2, IndexOptions var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public MongoClient listIndexes(String var1, Handler<AsyncResult<JsonArray>> var2);

    @Fluent
    public MongoClient dropIndex(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public MongoClient runCommand(String var1, JsonObject var2, Handler<AsyncResult<JsonObject>> var3);

    @Fluent
    public MongoClient distinct(String var1, String var2, String var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public MongoClient distinctWithQuery(String var1, String var2, String var3, JsonObject var4, Handler<AsyncResult<JsonArray>> var5);

    public ReadStream<JsonObject> distinctBatch(String var1, String var2, String var3);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4, int var5);

    public void close();
}

