/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoIterable;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicReference;

class MongoIterableStream
implements ReadStream<JsonObject> {
    private final Context context;
    private final MongoIterable<JsonObject> mongoIterable;
    private final int batchSize;
    private AsyncBatchCursor<JsonObject> batchCursor;
    private Deque<JsonObject> queue;
    private Handler<JsonObject> dataHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private boolean paused;
    private boolean readInProgress;
    private boolean closed;

    MongoIterableStream(Context context, MongoIterable<JsonObject> mongoIterable, int batchSize) {
        this.context = context;
        this.mongoIterable = mongoIterable;
        this.batchSize = batchSize;
    }

    public synchronized MongoIterableStream exceptionHandler(Handler<Throwable> handler) {
        this.checkClosed();
        this.exceptionHandler = handler;
        return this;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalArgumentException("Stream is closed");
        }
    }

    public synchronized MongoIterableStream handler(Handler<JsonObject> handler) {
        this.checkClosed();
        if (handler == null) {
            this.close();
        } else {
            this.dataHandler = handler;
            SingleResultCallback callback = (result, t) -> this.context.runOnContext(v -> {
                MongoIterableStream mongoIterableStream = this;
                synchronized (mongoIterableStream) {
                    if (t != null) {
                        this.close();
                        this.handleException(t);
                    } else {
                        this.batchCursor = result;
                        this.batchCursor.setBatchSize(this.batchSize);
                        if (this.canRead()) {
                            this.doRead();
                        }
                    }
                }
            });
            try {
                this.mongoIterable.batchCursor(callback);
            }
            catch (Exception e) {
                this.close();
                this.handleException(e);
            }
        }
        return this;
    }

    private boolean canRead() {
        return !this.paused && !this.closed;
    }

    public synchronized MongoIterableStream pause() {
        this.checkClosed();
        this.paused = true;
        return this;
    }

    public synchronized MongoIterableStream resume() {
        this.checkClosed();
        if (this.paused) {
            this.paused = false;
            if (this.dataHandler != null) {
                this.doRead();
            }
        }
        return this;
    }

    private synchronized void doRead() {
        if (this.readInProgress) {
            return;
        }
        this.readInProgress = true;
        if (this.queue == null) {
            this.queue = new ArrayDeque<JsonObject>(this.batchSize);
        }
        if (!this.queue.isEmpty()) {
            this.context.runOnContext(v -> this.emitQueued());
            return;
        }
        this.context.executeBlocking(fut -> this.batchCursor.next((result, t) -> {
            if (t != null) {
                fut.fail(t);
            } else {
                fut.complete((Object)(result == null ? Collections.emptyList() : result));
            }
        }), false, ar -> {
            MongoIterableStream mongoIterableStream = this;
            synchronized (mongoIterableStream) {
                if (ar.succeeded()) {
                    this.queue.addAll((Collection)ar.result());
                    if (this.queue.isEmpty()) {
                        this.close();
                        if (this.endHandler != null) {
                            this.endHandler.handle(null);
                        }
                    } else {
                        this.emitQueued();
                    }
                } else {
                    this.close();
                    this.handleException(ar.cause());
                }
            }
        });
    }

    private void handleException(Throwable cause) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)cause);
        }
    }

    private synchronized void emitQueued() {
        while (!this.queue.isEmpty() && this.canRead()) {
            this.dataHandler.handle((Object)this.queue.remove());
        }
        this.readInProgress = false;
        if (this.canRead()) {
            this.doRead();
        }
    }

    public synchronized MongoIterableStream endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    private void close() {
        this.closed = true;
        AtomicReference cursorRef = new AtomicReference();
        this.context.executeBlocking(fut -> {
            MongoIterableStream mongoIterableStream = this;
            synchronized (mongoIterableStream) {
                cursorRef.set(this.batchCursor);
            }
            AsyncBatchCursor cursor = (AsyncBatchCursor)cursorRef.get();
            if (cursor != null) {
                cursor.close();
            }
            fut.complete();
        }, false, null);
    }
}

