/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SslSettings;
import io.vertx.core.json.JsonObject;
import java.util.Optional;

class SSLSettingsParser {
    private final ConnectionString connectionString;
    private final JsonObject config;

    SSLSettingsParser(ConnectionString connectionString, JsonObject config) {
        this.connectionString = connectionString;
        this.config = config;
    }

    public SslSettings settings() {
        return this.fromConnectionString().orElseGet(this::fromConfiguration);
    }

    private Optional<SslSettings> fromConnectionString() {
        return Optional.ofNullable(this.connectionString).map(cs -> SslSettings.builder().applyConnectionString(cs).build());
    }

    private SslSettings fromConfiguration() {
        return SslSettings.builder().enabled(this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue()).invalidHostNameAllowed(this.config.getBoolean("sslInvalidHostNameAllowed", Boolean.valueOf(false)).booleanValue()).build();
    }
}

