/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.MongoIterableStream;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.DecoderContext;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoClientImpl
implements MongoClient {
    private static final Logger log = LoggerFactory.getLogger(MongoClientImpl.class);
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final AggregateOptions DEFAULT_AGGREGATE_OPTIONS = new AggregateOptions();
    private static final BulkWriteOptions DEFAULT_BULK_WRITE_OPTIONS = new BulkWriteOptions();
    private static final String ID_FIELD = "_id";
    private static final String DS_LOCAL_MAP_NAME = "__vertx.MongoClient.datasources";
    private final Vertx vertx;
    protected com.mongodb.async.client.MongoClient mongo;
    protected final MongoHolder holder;
    protected boolean useObjectId;

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        this.vertx = vertx;
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo();
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
    }

    @Override
    public void close() {
        this.holder.close();
    }

    @Override
    public MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.saveWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient saveWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        Object id = document.getValue(ID_FIELD);
        if (id == null) {
            coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> this.useObjectId ? document.getJsonObject(ID_FIELD).getString("$oid") : document.getString(ID_FIELD)));
        } else {
            JsonObject filter = new JsonObject();
            JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
            filter.put(ID_FIELD, encodedDocument.getValue(ID_FIELD));
            com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(true);
            coll.replaceOne((Bson)this.wrap(filter), (Object)encodedDocument, updateOptions, this.convertCallback(resultHandler, result -> null));
        }
        return this;
    }

    @Override
    public MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.insertWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient insertWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        boolean hasCustomId = document.containsKey(ID_FIELD);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.insertOne((Object)encodedDocument, this.convertCallback(resultHandler, wr -> {
            if (hasCustomId) {
                return null;
            }
            JsonObject decodedDocument = this.decodeKeyWhenUseObjectId(encodedDocument);
            return decodedDocument.getString(ID_FIELD);
        }));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.updateWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.updateCollectionWithOptions(collection, query, update, options, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(update, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        update = this.generateIdIfNeeded(query, update, options);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        JsonObjectBsonAdapter bupdate = this.wrap(this.encodeKeyWhenUseObjectId(update));
        if (options.isMulti()) {
            coll.updateMany((Bson)bquery, (Bson)bupdate, MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        } else {
            coll.updateOne((Bson)bquery, (Bson)bupdate, MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        }
        return this;
    }

    private JsonObject generateIdIfNeeded(JsonObject query, JsonObject update, UpdateOptions options) {
        if (options.isUpsert() && !update.containsKey(ID_FIELD) && !this.useObjectId) {
            JsonObject setId = update.getJsonObject("$setOnInsert", new JsonObject());
            String id = query.containsKey(ID_FIELD) ? query.getString(ID_FIELD) : JsonObjectCodec.generateHexObjectId();
            setId.put(ID_FIELD, id);
            update.put("$setOnInsert", setId);
        }
        return update;
    }

    @Override
    @Deprecated
    public MongoClient replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.replaceWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.replaceDocumentsWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        return this.replaceDocumentsWithOptions(collection, query, replace, options, this.toVoidAsyncResult(resultHandler));
    }

    @Override
    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(replace, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        coll.replaceOne((Bson)bquery, (Object)this.encodeKeyWhenUseObjectId(replace), MongoClientImpl.mongoUpdateOptions(options), this.toMongoClientUpdateResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        return this.findBatchWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        FindIterable<JsonObject> view = this.doFind(collection, this.encodeKeyWhenUseObjectId(query), options);
        ArrayList results = new ArrayList();
        view.into(results, this.convertCallback(resultHandler, wr -> {
            results.forEach(this::decodeKeyWhenUseObjectId);
            return results;
        }));
        return this;
    }

    @Override
    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        FindIterable<JsonObject> view = this.doFind(collection, query, options);
        return new MongoIterableStream(this.vertx.getOrCreateContext(), (MongoIterable<JsonObject>)view, options.getBatchSize());
    }

    @Override
    public MongoClient findOne(String collection, JsonObject query, @Nullable JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bfields = this.wrap(fields);
        this.getCollection(collection).find((Bson)bquery).projection((Bson)bfields).first(this.convertCallback(resultHandler, object -> {
            if (object == null) {
                return null;
            }
            return this.decodeKeyWhenUseObjectId((JsonObject)object);
        }));
        return this;
    }

    @Override
    public MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.findOneAndUpdateWithOptions(collection, query, update, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(update, "update cannot be null");
        Objects.requireNonNull(findOptions, "find options cannot be null");
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bupdate = this.wrap(update);
        FindOneAndUpdateOptions foauOptions = new FindOneAndUpdateOptions();
        foauOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foauOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foauOptions.upsert(updateOptions.isUpsert());
        foauOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.findOneAndUpdate((Bson)bquery, (Bson)bupdate, foauOptions, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.findOneAndReplaceWithOptions(collection, query, update, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(findOptions, "find options cannot be null");
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndReplaceOptions foarOptions = new FindOneAndReplaceOptions();
        foarOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foarOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foarOptions.upsert(updateOptions.isUpsert());
        foarOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.findOneAndReplace((Bson)bquery, (Object)replace, foarOptions, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.findOneAndDeleteWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(findOptions, "find options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndDeleteOptions foadOptions = new FindOneAndDeleteOptions();
        foadOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foadOptions.projection((Bson)this.wrap(findOptions.getFields()));
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.findOneAndDelete((Bson)bquery, foadOptions, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.count((Bson)bquery, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.removeDocumentsWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.removeDocumentsWithOptions(collection, query, writeOption, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        coll.deleteMany((Bson)bquery, this.toMongoClientDeleteResult(resultHandler));
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeOneWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.removeDocumentWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    public MongoClient removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.removeDocumentWithOptions(collection, query, writeOption, this.toVoidAsyncResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        coll.deleteOne((Bson)bquery, this.toMongoClientDeleteResult(resultHandler));
        return this;
    }

    @Override
    public MongoClient bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.bulkWriteWithOptions(collection, operations, DEFAULT_BULK_WRITE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(operations, "operations cannot be null");
        Objects.requireNonNull(bulkWriteOptions, "bulkWriteOptions cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, bulkWriteOptions.getWriteOption());
        List<WriteModel<JsonObject>> bulkOperations = this.convertBulkOperations(operations);
        coll.bulkWrite(bulkOperations, MongoClientImpl.mongoBulkWriteOptions(bulkWriteOptions), this.toMongoClientBulkWriteResult(resultHandler));
        return this;
    }

    private static com.mongodb.client.model.BulkWriteOptions mongoBulkWriteOptions(BulkWriteOptions bulkWriteOptions) {
        com.mongodb.client.model.BulkWriteOptions mongoBulkOptions = new com.mongodb.client.model.BulkWriteOptions().ordered(bulkWriteOptions.isOrdered());
        return mongoBulkOptions;
    }

    private List<WriteModel<JsonObject>> convertBulkOperations(List<BulkOperation> operations) {
        ArrayList<WriteModel<JsonObject>> result = new ArrayList<WriteModel<JsonObject>>(operations.size());
        block6: for (BulkOperation bulkOperation : operations) {
            switch (bulkOperation.getType()) {
                case DELETE: {
                    Bson bsonFilter = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new DeleteManyModel(bsonFilter));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new DeleteOneModel(bsonFilter));
                    continue block6;
                }
                case INSERT: {
                    result.add((WriteModel<JsonObject>)new InsertOneModel((Object)this.encodeKeyWhenUseObjectId(bulkOperation.getDocument())));
                    continue block6;
                }
                case REPLACE: {
                    result.add((WriteModel<JsonObject>)new ReplaceOneModel(MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter())), (Object)bulkOperation.getDocument(), new com.mongodb.client.model.UpdateOptions().upsert(bulkOperation.isUpsert())));
                    continue block6;
                }
                case UPDATE: {
                    Bson filter = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    Bson document = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getDocument()));
                    com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(bulkOperation.isUpsert());
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new UpdateManyModel(filter, document, updateOptions));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new UpdateOneModel(filter, document, updateOptions));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown bulk operation type: " + bulkOperation.getClass());
        }
        return result;
    }

    @Override
    public MongoClient createCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.holder.db.createCollection(collection, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        ArrayList names = new ArrayList();
        Context context = this.vertx.getOrCreateContext();
        this.holder.db.listCollectionNames().into(names, (res, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)names));
            }
        }));
        return this;
    }

    @Override
    public MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.drop(this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        return this.createIndexWithOptions(collection, key, new IndexOptions(), resultHandler);
    }

    @Override
    public MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(key, "fieldName cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        com.mongodb.client.model.IndexOptions driverOpts = new com.mongodb.client.model.IndexOptions().background(options.isBackground()).unique(options.isUnique()).name(options.getName()).sparse(options.isSparse()).expireAfter(options.getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(options.getVersion()).weights(MongoClientImpl.toBson(options.getWeights())).defaultLanguage(options.getDefaultLanguage()).languageOverride(options.getLanguageOverride()).textVersion(options.getTextVersion()).sphereVersion(options.getSphereVersion()).bits(options.getBits()).min(options.getMin()).max(options.getMax()).bucketSize(options.getBucketSize()).storageEngine(MongoClientImpl.toBson(options.getStorageEngine())).partialFilterExpression(MongoClientImpl.toBson(options.getPartialFilterExpression()));
        coll.createIndex((Bson)this.wrap(key), driverOpts, this.wrapCallback(this.toVoidAsyncResult(resultHandler)));
        return this;
    }

    private static @Nullable Bson toBson(@Nullable JsonObject json) {
        return json == null ? null : BsonDocument.parse((String)json.encode());
    }

    @Override
    public MongoClient listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ListIndexesIterable indexes = coll.listIndexes(JsonObject.class);
        if (indexes != null) {
            this.convertMongoIterable((MongoIterable)indexes, resultHandler);
        }
        return this;
    }

    @Override
    public MongoClient dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(indexName, "indexName cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.dropIndex(indexName, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(commandName, "commandName cannot be null");
        Objects.requireNonNull(command, "command cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObject json = new JsonObject();
        Object commandVal = command.getValue(commandName);
        if (commandVal == null) {
            throw new IllegalArgumentException("commandBody does not contain key for " + commandName);
        }
        json.put(commandName, commandVal);
        command.forEach(entry -> {
            if (!((String)entry.getKey()).equals(commandName)) {
                json.put((String)entry.getKey(), entry.getValue());
            }
        });
        this.holder.db.runCommand((Bson)this.wrap(json), JsonObject.class, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, new JsonObject(), resultHandler);
    }

    @Override
    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) {
        try {
            DistinctIterable<?> distinctValues = this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query);
            if (distinctValues != null) {
                this.convertMongoIterable((MongoIterable)distinctValues, resultHandler);
            }
        }
        catch (ClassNotFoundException e) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)e));
        }
        return this;
    }

    @Override
    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, new JsonObject());
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, 20);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        try {
            MongoIterable distinctValues = this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query).map(value -> new JsonObject().put(fieldName, value));
            return new MongoIterableStream(this.vertx.getOrCreateContext(), (MongoIterable<JsonObject>)distinctValues, batchSize);
        }
        catch (ClassNotFoundException e) {
            return new FailedStream(e);
        }
    }

    @Override
    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        return this.aggregateWithOptions(collection, pipeline, DEFAULT_AGGREGATE_OPTIONS);
    }

    @Override
    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        AggregateIterable<JsonObject> view = this.doAggregate(collection, pipeline, options);
        return new MongoIterableStream(this.vertx.getOrCreateContext(), (MongoIterable<JsonObject>)view, options.getBatchSize());
    }

    private void convertMongoIterable(MongoIterable iterable, Handler<AsyncResult<JsonArray>> resultHandler) {
        ArrayList results = new ArrayList();
        try {
            Context context = this.vertx.getOrCreateContext();
            iterable.into(results, (result, throwable) -> context.runOnContext(v -> {
                if (throwable != null) {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
                } else {
                    resultHandler.handle((Object)Future.succeededFuture((Object)new JsonArray((List)result)));
                }
            }));
        }
        catch (Exception unhandledEx) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)unhandledEx));
        }
    }

    private DistinctIterable<?> findDistinctValuesWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) throws ClassNotFoundException {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(fieldName, "fieldName cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        MongoCollection<JsonObject> mongoCollection = this.getCollection(collection);
        Class<?> resultClass = this.getClass().getClassLoader().loadClass(resultClassname);
        return mongoCollection.distinct(fieldName, (Bson)bquery, resultClass);
    }

    private AggregateIterable<JsonObject> doAggregate(String collection, JsonArray pipeline, AggregateOptions aggregateOptions) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(pipeline, "pipeline cannot be null");
        Objects.requireNonNull(aggregateOptions, "aggregateOptions cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ArrayList bpipeline = new ArrayList(pipeline.size());
        pipeline.getList().forEach(entry -> bpipeline.add(this.wrap(JsonObject.mapFrom((Object)entry))));
        AggregateIterable aggregate = coll.aggregate(bpipeline, JsonObject.class);
        if (aggregateOptions.getBatchSize() != -1) {
            aggregate.batchSize(aggregateOptions.getBatchSize());
        }
        if (aggregateOptions.getMaxTime() > 0L) {
            aggregate.maxTime(aggregateOptions.getMaxTime(), TimeUnit.MILLISECONDS);
        }
        if (aggregateOptions.getMaxAwaitTime() > 0L) {
            aggregate.maxAwaitTime(aggregateOptions.getMaxAwaitTime(), TimeUnit.MILLISECONDS);
        }
        if (aggregateOptions.getAllowDiskUse() != null) {
            aggregate.allowDiskUse(aggregateOptions.getAllowDiskUse());
        }
        return aggregate;
    }

    private JsonObject encodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idString = json.getValue(ID_FIELD, null);
        if (idString instanceof String && ObjectId.isValid((String)((String)idString))) {
            json.put(ID_FIELD, new JsonObject().put("$oid", idString));
        }
        return json;
    }

    private JsonObject decodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idField = json.getValue(ID_FIELD, null);
        if (!(idField instanceof JsonObject)) {
            return json;
        }
        Object idString = ((JsonObject)idField).getValue("$oid", null);
        if (!(idString instanceof String)) {
            return json;
        }
        json.put(ID_FIELD, (String)idString);
        return json;
    }

    private <T, R> SingleResultCallback<T> convertCallback(Handler<AsyncResult<R>> resultHandler, Function<T, R> converter) {
        Context context = this.vertx.getOrCreateContext();
        return (result, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(converter.apply(result)));
            }
        });
    }

    private <T> Handler<AsyncResult<T>> toVoidAsyncResult(Handler<AsyncResult<Void>> resultHandler) {
        return result -> {
            if (result.succeeded()) {
                resultHandler.handle((Object)Future.succeededFuture(null));
            } else {
                resultHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        };
    }

    private SingleResultCallback<UpdateResult> toMongoClientUpdateResult(Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        return this.convertCallback(resultHandler, result -> {
            if (result.wasAcknowledged()) {
                return this.convertToMongoClientUpdateResult(result.getMatchedCount(), result.getUpsertedId(), result.getModifiedCount());
            }
            return null;
        });
    }

    private SingleResultCallback<DeleteResult> toMongoClientDeleteResult(Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        return this.convertCallback(resultHandler, result -> {
            if (result.wasAcknowledged()) {
                return new MongoClientDeleteResult(result.getDeletedCount());
            }
            return null;
        });
    }

    private SingleResultCallback<BulkWriteResult> toMongoClientBulkWriteResult(Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        return this.convertCallback(resultHandler, result -> {
            if (result.wasAcknowledged()) {
                return this.convertToMongoClientBulkWriteResult(result.getInsertedCount(), result.getMatchedCount(), result.getDeletedCount(), result.isModifiedCountAvailable() ? result.getModifiedCount() : 0, result.getUpserts());
            }
            return null;
        });
    }

    private MongoClientBulkWriteResult convertToMongoClientBulkWriteResult(int insertedCount, int matchedCount, int deletedCount, int modifiedCount, List<BulkWriteUpsert> upserts) {
        List<JsonObject> upsertResult = upserts.stream().map(upsert -> {
            JsonObject upsertValue = this.convertUpsertId(upsert.getId());
            upsertValue.put("index", Integer.valueOf(upsert.getIndex()));
            return upsertValue;
        }).collect(Collectors.toList());
        return new MongoClientBulkWriteResult(insertedCount, matchedCount, deletedCount, modifiedCount, upsertResult);
    }

    private <T> SingleResultCallback<T> wrapCallback(Handler<AsyncResult<T>> resultHandler) {
        Context context = this.vertx.getOrCreateContext();
        return (result, error) -> context.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    private FindIterable<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        FindIterable find = coll.find((Bson)bquery, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Bson)this.wrap(options.getSort()));
        }
        if (options.getFields() != null) {
            find.projection((Bson)this.wrap(options.getFields()));
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, @Nullable WriteOption writeOption) {
        MongoCollection coll = this.holder.db.getCollection(name, JsonObject.class);
        if (coll != null && writeOption != null) {
            coll = coll.withWriteConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return coll;
    }

    private static com.mongodb.client.model.UpdateOptions mongoUpdateOptions(UpdateOptions options) {
        return new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
    }

    private @Nullable JsonObjectBsonAdapter wrap(@Nullable JsonObject jsonObject) {
        return jsonObject == null ? null : new JsonObjectBsonAdapter(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MongoHolder> map, String dataSourceName) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoHolder lookupHolder(String datasourceName, JsonObject config) {
        Vertx vertx = this.vertx;
        synchronized (vertx) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            MongoHolder theHolder = (MongoHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new MongoHolder(config, () -> this.removeFromMap((LocalMap<String, MongoHolder>)map, datasourceName));
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    private MongoClientUpdateResult convertToMongoClientUpdateResult(long docMatched, BsonValue upsertId, long docModified) {
        return new MongoClientUpdateResult(docMatched, this.convertUpsertId(upsertId), docModified);
    }

    private @Nullable JsonObject convertUpsertId(@Nullable BsonValue upsertId) {
        JsonObject jsonUpsertId;
        if (upsertId != null) {
            JsonObjectCodec jsonObjectCodec = new JsonObjectCodec(new JsonObject());
            BsonDocument upsertIdDocument = new BsonDocument();
            upsertIdDocument.append(ID_FIELD, upsertId);
            BsonDocumentReader bsonDocumentReader = new BsonDocumentReader(upsertIdDocument);
            jsonUpsertId = (JsonObject)jsonObjectCodec.decode((BsonReader)bsonDocumentReader, DecoderContext.builder().build());
        } else {
            jsonUpsertId = null;
        }
        return jsonUpsertId;
    }

    private static class FailedStream
    implements ReadStream<JsonObject> {
        private final ClassNotFoundException e;

        public FailedStream(ClassNotFoundException e) {
            this.e = e;
        }

        public ReadStream<JsonObject> exceptionHandler(Handler<Throwable> handler) {
            handler.handle((Object)this.e);
            return this;
        }

        public ReadStream<JsonObject> handler(Handler<JsonObject> handler) {
            return this;
        }

        public ReadStream<JsonObject> pause() {
            return this;
        }

        public ReadStream<JsonObject> fetch(long l) {
            return this;
        }

        public ReadStream<JsonObject> resume() {
            return this;
        }

        public ReadStream<JsonObject> endHandler(Handler<Void> endHandler) {
            return this;
        }
    }

    private static class MongoHolder
    implements Shareable {
        com.mongodb.async.client.MongoClient mongo;
        MongoDatabase db;
        JsonObject config;
        Runnable closeRunner;
        int refCount = 1;

        public MongoHolder(JsonObject config, Runnable closeRunner) {
            this.config = config;
            this.closeRunner = closeRunner;
        }

        synchronized com.mongodb.async.client.MongoClient mongo() {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(this.config);
                this.mongo = MongoClients.create((MongoClientSettings)parser.settings());
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close() {
            if (--this.refCount == 0) {
                if (this.mongo != null) {
                    this.mongo.close();
                }
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
            }
        }
    }
}

