/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

class CredentialListParser {
    private final List<MongoCredential> credentials;

    public CredentialListParser(JsonObject config) {
        String username = config.getString("username");
        AuthenticationMechanism mechanism = null;
        String authMechanism = config.getString("authMechanism");
        if (authMechanism != null) {
            mechanism = this.getAuthenticationMechanism(authMechanism);
        }
        this.credentials = new ArrayList<MongoCredential>();
        if (username == null) {
            if (mechanism == AuthenticationMechanism.MONGODB_X509) {
                this.credentials.add(MongoCredential.createMongoX509Credential());
            }
        } else {
            MongoCredential credential;
            String passwd = config.getString("password");
            char[] password = passwd == null ? null : passwd.toCharArray();
            String authSource = config.getString("authSource", config.getString("db_name", "DEFAULT_DB"));
            String gssapiServiceName = config.getString("gssapiServiceName");
            if (mechanism == AuthenticationMechanism.GSSAPI) {
                credential = MongoCredential.createGSSAPICredential((String)username);
                credential = this.getMongoCredential(gssapiServiceName, credential);
            } else if (mechanism == AuthenticationMechanism.PLAIN) {
                credential = MongoCredential.createPlainCredential((String)username, (String)authSource, (char[])password);
            } else if (mechanism == AuthenticationMechanism.MONGODB_X509) {
                credential = MongoCredential.createMongoX509Credential((String)username);
            } else if (mechanism == AuthenticationMechanism.SCRAM_SHA_1) {
                credential = MongoCredential.createScramSha1Credential((String)username, (String)authSource, (char[])password);
            } else if (mechanism == AuthenticationMechanism.SCRAM_SHA_256) {
                credential = MongoCredential.createScramSha256Credential((String)username, (String)authSource, (char[])password);
            } else if (mechanism == null) {
                credential = MongoCredential.createCredential((String)username, (String)authSource, (char[])password);
            } else {
                throw new IllegalArgumentException("Unsupported authentication mechanism " + mechanism);
            }
            this.credentials.add(credential);
        }
    }

    private MongoCredential getMongoCredential(String gssapiServiceName, MongoCredential credential) {
        if (gssapiServiceName != null) {
            credential = credential.withMechanismProperty("SERVICE_NAME", (Object)gssapiServiceName);
        }
        return credential;
    }

    private AuthenticationMechanism getAuthenticationMechanism(String authMechanism) {
        AuthenticationMechanism mechanism;
        try {
            mechanism = AuthenticationMechanism.fromMechanismName((String)authMechanism);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid authMechanism '" + authMechanism + "'");
        }
        return mechanism;
    }

    public List<MongoCredential> credentials() {
        return this.credentials;
    }
}

