/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.WriteOption;

@DataObject
public class UpdateOptions {
    public static final boolean DEFAULT_UPSERT = false;
    public static final boolean DEFAULT_MULTI = false;
    public static final boolean DEFAULT_RETURN_NEW_DOCUMENT = false;
    private WriteOption writeOption;
    private boolean upsert;
    private boolean multi;
    private boolean returnNewDocument;
    private JsonArray arrayFilters;

    public UpdateOptions() {
        this.upsert = false;
        this.multi = false;
        this.returnNewDocument = false;
    }

    public UpdateOptions(boolean upsert) {
        this.upsert = upsert;
        this.multi = false;
        this.returnNewDocument = false;
    }

    public UpdateOptions(boolean upsert, boolean multi) {
        this.upsert = upsert;
        this.multi = multi;
    }

    public UpdateOptions(UpdateOptions other) {
        this.writeOption = other.writeOption;
        this.upsert = other.upsert;
        this.multi = other.multi;
        this.returnNewDocument = other.returnNewDocument;
        this.arrayFilters = other.arrayFilters;
    }

    public UpdateOptions(JsonObject json) {
        String wo = json.getString("writeOption");
        if (wo != null) {
            this.writeOption = WriteOption.valueOf(wo.toUpperCase());
        }
        this.upsert = json.getBoolean("upsert", Boolean.valueOf(false));
        this.multi = json.getBoolean("multi", Boolean.valueOf(false));
        this.returnNewDocument = json.getBoolean("return_new_document", Boolean.valueOf(false));
        this.arrayFilters = json.getJsonArray("arrayFilters", null);
    }

    public WriteOption getWriteOption() {
        return this.writeOption;
    }

    public UpdateOptions setWriteOption(WriteOption writeOption) {
        this.writeOption = writeOption;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public UpdateOptions setUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public boolean isReturningNewDocument() {
        return this.returnNewDocument;
    }

    public UpdateOptions setReturningNewDocument(boolean returnNewDocument) {
        this.returnNewDocument = returnNewDocument;
        return this;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public UpdateOptions setMulti(boolean multi) {
        this.multi = multi;
        return this;
    }

    public JsonArray getArrayFilters() {
        return this.arrayFilters;
    }

    public UpdateOptions setArrayFilters(JsonArray arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.writeOption != null) {
            json.put("writeOption", (Object)this.writeOption.name());
        }
        if (this.upsert) {
            json.put("upsert", (Object)true);
        }
        if (this.multi) {
            json.put("multi", (Object)true);
        }
        if (this.returnNewDocument) {
            json.put("return_new_document", (Object)true);
        }
        if (this.arrayFilters != null && !this.arrayFilters.isEmpty()) {
            json.put("arrayFilters", (Object)this.arrayFilters);
        }
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOptions options = (UpdateOptions)o;
        if (this.multi != options.multi) {
            return false;
        }
        if (this.upsert != options.upsert) {
            return false;
        }
        if (this.writeOption != options.writeOption) {
            return false;
        }
        if (this.returnNewDocument != options.returnNewDocument) {
            return false;
        }
        return this.arrayFilters == options.arrayFilters;
    }

    public int hashCode() {
        int result = this.writeOption != null ? this.writeOption.hashCode() : 0;
        result = 31 * result + (this.upsert ? 1 : 0);
        result = 31 * result + (this.multi ? 1 : 0);
        result = 31 * result + (this.returnNewDocument ? 1 : 0);
        result = 31 * result + (this.arrayFilters != null ? this.arrayFilters.hashCode() : 0);
        return result;
    }
}

