/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptionsConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class FindOptions {
    public static final int DEFAULT_LIMIT = -1;
    public static final int DEFAULT_SKIP = 0;
    public static final int DEFAULT_BATCH_SIZE = 20;
    private JsonObject fields;
    private JsonObject sort;
    private int limit;
    private int skip;
    private int batchSize;
    private String hint;

    public FindOptions() {
        this.fields = new JsonObject();
        this.sort = new JsonObject();
        this.limit = -1;
        this.skip = 0;
        this.batchSize = 20;
        this.hint = new String();
    }

    public FindOptions(FindOptions options) {
        this.fields = options.fields != null ? options.fields.copy() : new JsonObject();
        this.sort = options.sort != null ? options.sort.copy() : new JsonObject();
        this.limit = options.limit;
        this.skip = options.skip;
        this.batchSize = options.batchSize;
        this.hint = options.hint;
    }

    public FindOptions(JsonObject options) {
        this();
        FindOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FindOptionsConverter.toJson(this, json);
        return json;
    }

    public JsonObject getFields() {
        return this.fields;
    }

    public FindOptions setFields(JsonObject fields) {
        this.fields = fields;
        return this;
    }

    public JsonObject getSort() {
        return this.sort;
    }

    public FindOptions setSort(JsonObject sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public FindOptions setHint(String hint) {
        this.hint = hint;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindOptions that = (FindOptions)o;
        if (this.limit != that.limit) {
            return false;
        }
        if (this.skip != that.skip) {
            return false;
        }
        if (this.batchSize != that.batchSize) {
            return false;
        }
        if (this.fields != null ? !this.fields.equals((Object)that.fields) : that.fields != null) {
            return false;
        }
        if (this.hint != null ? !this.hint.equals(that.hint) : that.hint != null) {
            return false;
        }
        return this.sort != null ? this.sort.equals((Object)that.sort) : that.sort == null;
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
        result = 31 * result + this.limit;
        result = 31 * result + this.skip;
        result = 31 * result + this.batchSize;
        result = 31 * result + (this.hint != null ? this.hint.hashCode() : 0);
        return result;
    }
}

