/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonReader;
import org.bson.BsonValue;
import org.bson.codecs.DecoderContext;

class Utils {
    static final String ID_FIELD = "_id";

    static MongoClientDeleteResult toMongoClientDeleteResult(DeleteResult deleteResult) {
        return deleteResult.wasAcknowledged() ? new MongoClientDeleteResult(deleteResult.getDeletedCount()) : null;
    }

    static MongoClientUpdateResult toMongoClientUpdateResult(UpdateResult updateResult) {
        return updateResult.wasAcknowledged() ? new MongoClientUpdateResult(updateResult.getMatchedCount(), Utils.convertUpsertId(updateResult.getUpsertedId()), updateResult.getModifiedCount()) : null;
    }

    static MongoClientBulkWriteResult toMongoClientBulkWriteResult(BulkWriteResult bulkWriteResult) {
        if (!bulkWriteResult.wasAcknowledged()) {
            return null;
        }
        List<JsonObject> upsertResult = bulkWriteResult.getUpserts().stream().map(upsert -> {
            JsonObject upsertValue = Utils.convertUpsertId(upsert.getId());
            upsertValue.put("index", (Object)upsert.getIndex());
            return upsertValue;
        }).collect(Collectors.toList());
        return new MongoClientBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), bulkWriteResult.getModifiedCount(), upsertResult);
    }

    private static JsonObject convertUpsertId(BsonValue upsertId) {
        JsonObject jsonUpsertId;
        if (upsertId != null) {
            JsonObjectCodec jsonObjectCodec = new JsonObjectCodec(new JsonObject());
            BsonDocument upsertIdDocument = new BsonDocument();
            upsertIdDocument.append(ID_FIELD, upsertId);
            BsonDocumentReader bsonDocumentReader = new BsonDocumentReader(upsertIdDocument);
            jsonUpsertId = (JsonObject)jsonObjectCodec.decode((BsonReader)bsonDocumentReader, DecoderContext.builder().build());
        } else {
            jsonUpsertId = null;
        }
        return jsonUpsertId;
    }

    static <T> void setHandler(Future<T> future, Handler<AsyncResult<T>> handler) {
        Objects.requireNonNull(future, "future must not be null");
        if (handler != null) {
            future.onComplete(handler);
        }
    }

    private Utils() {
    }
}

