/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.Alternate;
import io.vertx.ext.mongo.CaseFirst;
import io.vertx.ext.mongo.CollationOptionsConverter;
import io.vertx.ext.mongo.MaxVariable;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class CollationOptions {
    public static final Boolean DEFAULT_CASE_LEVEL = false;
    public static final CaseFirst DEFAULT_CASE_FIRST = CaseFirst.off;
    public static final Alternate DEFAULT_ALTERNATE = Alternate.NON_IGNORABLE;
    public static final Integer DEFAULT_STRENGTH = 3;
    public static final Boolean DEFAULT_NUMERIC_ORDERING = false;
    public static final Boolean DEFAULT_BACKWARDS = false;
    public static final Boolean DEFAULT_NORMALIZATION = false;
    public static final MaxVariable DEFAULT_MAX_VARIABLE = MaxVariable.punct;
    private static final String DEFAULT_LOCALE = Locale.getDefault().toString();
    private String locale;
    private boolean caseLevel;
    private CaseFirst caseFirst;
    private int strength;
    private boolean numericOrdering;
    private String alternate;
    private MaxVariable maxVariable;
    private boolean backwards;
    private boolean normalization;

    public CollationOptions() {
        this.locale = DEFAULT_LOCALE;
        this.caseLevel = DEFAULT_CASE_LEVEL;
        this.caseFirst = DEFAULT_CASE_FIRST;
        this.strength = DEFAULT_STRENGTH;
        this.numericOrdering = DEFAULT_NUMERIC_ORDERING;
        this.backwards = DEFAULT_BACKWARDS;
        this.maxVariable = DEFAULT_MAX_VARIABLE;
        this.normalization = DEFAULT_NORMALIZATION;
        this.alternate = DEFAULT_ALTERNATE.toString();
    }

    public CollationOptions(CollationOptions options) {
        this.locale = options.locale;
        this.caseLevel = options.caseLevel;
        this.caseFirst = options.caseFirst;
        this.strength = options.strength;
        this.numericOrdering = options.numericOrdering;
        this.alternate = options.alternate;
        this.maxVariable = options.maxVariable;
        this.backwards = options.backwards;
        this.normalization = options.normalization;
    }

    public Collation toMongoDriverObject() {
        return Collation.builder().collationAlternate(CollationAlternate.fromString((String)this.getAlternate())).backwards(Boolean.valueOf(this.isBackwards())).caseLevel(Boolean.valueOf(this.isCaseLevel())).collationCaseFirst(CollationCaseFirst.fromString((String)this.getCaseFirst().name())).collationMaxVariable(CollationMaxVariable.fromString((String)this.getMaxVariable().name())).collationStrength(CollationStrength.fromInt((int)this.getStrength())).locale(this.getLocale()).numericOrdering(Boolean.valueOf(this.isNumericOrdering())).collationAlternate(CollationAlternate.fromString((String)this.getAlternate())).normalization(Boolean.valueOf(this.isNormalization())).build();
    }

    public CollationOptions(JsonObject json) {
        CollationOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollationOptions that = (CollationOptions)o;
        return this.isCaseLevel() == that.isCaseLevel() && this.getStrength() == that.getStrength() && this.isNumericOrdering() == that.isNumericOrdering() && this.isBackwards() == that.isBackwards() && this.isNormalization() == that.isNormalization() && Objects.equals(this.getLocale(), that.getLocale()) && this.getCaseFirst() == that.getCaseFirst() && this.getAlternate() == that.getAlternate() && this.getMaxVariable() == that.getMaxVariable();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getLocale(), this.isCaseLevel(), this.getCaseFirst(), this.getStrength(), this.isNumericOrdering(), this.getAlternate(), this.getMaxVariable(), this.isBackwards(), this.isNormalization()});
    }

    public boolean isNormalization() {
        return this.normalization;
    }

    public CollationOptions setNormalization(boolean normalization) {
        this.normalization = normalization;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CollationOptionsConverter.toJson(this, json);
        return json;
    }

    public String getLocale() {
        return this.locale;
    }

    public CollationOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public boolean isCaseLevel() {
        return this.caseLevel;
    }

    public CollationOptions setCaseLevel(boolean caseLevel) {
        this.caseLevel = caseLevel;
        return this;
    }

    public CaseFirst getCaseFirst() {
        return this.caseFirst;
    }

    public CollationOptions setCaseFirst(CaseFirst caseFirst) {
        this.caseFirst = caseFirst;
        return this;
    }

    public int getStrength() {
        return this.strength;
    }

    public CollationOptions setStrength(int strength) {
        if (strength < 1 || strength > 5) {
            throw new IllegalArgumentException("Unsupported strength level: Must be 1-5");
        }
        this.strength = strength;
        return this;
    }

    public boolean isNumericOrdering() {
        return this.numericOrdering;
    }

    public CollationOptions setNumericOrdering(boolean numericOrdering) {
        this.numericOrdering = numericOrdering;
        return this;
    }

    public String getAlternate() {
        return this.alternate;
    }

    Alternate alternate() {
        return Alternate.fromString(this.alternate);
    }

    public CollationOptions setAlternate(String alternate) {
        this.alternate = alternate;
        return this;
    }

    @GenIgnore
    CollationOptions alternate(Alternate alternate) {
        this.alternate = alternate.toString();
        return this;
    }

    public MaxVariable getMaxVariable() {
        return this.maxVariable;
    }

    public CollationOptions setMaxVariable(MaxVariable maxVariable) {
        this.maxVariable = maxVariable;
        return this;
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public CollationOptions setBackwards(boolean backwards) {
        this.backwards = backwards;
        return this;
    }
}

