/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.mongo.CaseFirst;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.MaxVariable;
import java.util.Base64;
import java.util.Map;

public class CollationOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, CollationOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "alternate": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setAlternate((String)member.getValue());
                    break;
                }
                case "backwards": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBackwards((Boolean)member.getValue());
                    break;
                }
                case "caseFirst": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setCaseFirst(CaseFirst.valueOf((String)member.getValue()));
                    break;
                }
                case "caseLevel": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCaseLevel((Boolean)member.getValue());
                    break;
                }
                case "locale": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocale((String)member.getValue());
                    break;
                }
                case "maxVariable": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMaxVariable(MaxVariable.valueOf((String)member.getValue()));
                    break;
                }
                case "normalization": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNormalization((Boolean)member.getValue());
                    break;
                }
                case "numericOrdering": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNumericOrdering((Boolean)member.getValue());
                    break;
                }
                case "strength": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setStrength(((Number)member.getValue()).intValue());
                }
            }
        }
    }

    public static void toJson(CollationOptions obj, JsonObject json) {
        CollationOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(CollationOptions obj, Map<String, Object> json) {
        if (obj.getAlternate() != null) {
            json.put("alternate", obj.getAlternate());
        }
        json.put("backwards", obj.isBackwards());
        if (obj.getCaseFirst() != null) {
            json.put("caseFirst", obj.getCaseFirst().name());
        }
        json.put("caseLevel", obj.isCaseLevel());
        if (obj.getLocale() != null) {
            json.put("locale", obj.getLocale());
        }
        if (obj.getMaxVariable() != null) {
            json.put("maxVariable", obj.getMaxVariable().name());
        }
        json.put("normalization", obj.isNormalization());
        json.put("numericOrdering", obj.isNumericOrdering());
        json.put("strength", obj.getStrength());
    }
}

