/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.assertions.Assertions;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptionsConverter;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;

@DataObject(generateConverter=true)
public class CountOptions {
    private static final TimeUnit DEFAULT_MAX_TIME_TIMEUNIT = TimeUnit.MILLISECONDS;
    private JsonObject hint;
    private String hintString;
    private int limit;
    private int skip;
    private long maxTime;
    private CollationOptions collation;

    public CountOptions() {
    }

    public CountOptions(CountOptions countOptions) {
        this.hint = countOptions.getHint();
        this.hintString = countOptions.getHintString();
        this.limit = countOptions.getLimit();
        this.skip = countOptions.getSkip();
        this.maxTime = countOptions.getMaxTime(DEFAULT_MAX_TIME_TIMEUNIT);
        this.collation = countOptions.getCollation();
    }

    public CountOptions(JsonObject json) {
        CountOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CountOptionsConverter.toJson(this, json);
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountOptions that = (CountOptions)o;
        return this.getLimit() == that.getLimit() && this.getSkip() == that.getSkip() && this.maxTime == that.maxTime && Objects.equals(this.getHint(), that.getHint()) && Objects.equals(this.getHintString(), that.getHintString()) && Objects.equals(this.getCollation(), that.getCollation());
    }

    public int hashCode() {
        return Objects.hash(this.getHint(), this.getHintString(), this.getLimit(), this.getSkip(), this.maxTime, this.getCollation());
    }

    public com.mongodb.client.model.CountOptions toMongoDriverObject() {
        com.mongodb.client.model.CountOptions options = new com.mongodb.client.model.CountOptions();
        if (this.collation != null) {
            options.collation(this.collation.toMongoDriverObject());
        }
        return options.hint((Bson)(this.hint == null ? null : new JsonObjectBsonAdapter(this.hint))).hintString(this.hintString).limit(this.limit).skip(this.skip).maxTime(this.maxTime, DEFAULT_MAX_TIME_TIMEUNIT);
    }

    public JsonObject getHint() {
        return this.hint;
    }

    public String getHintString() {
        return this.hintString;
    }

    public CountOptions setHint(JsonObject hint) {
        this.hint = hint;
        return this;
    }

    public CountOptions setHintString(String hint) {
        this.hintString = hint;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public CountOptions setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public CountOptions setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime() {
        return this.getMaxTime(DEFAULT_MAX_TIME_TIMEUNIT);
    }

    public CountOptions setMaxTime(long maxTimeMS) {
        return this.setMaxTime(maxTimeMS, DEFAULT_MAX_TIME_TIMEUNIT);
    }

    @GenIgnore
    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        return timeUnit.convert(this.maxTime, DEFAULT_MAX_TIME_TIMEUNIT);
    }

    @GenIgnore
    public CountOptions setMaxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTime = DEFAULT_MAX_TIME_TIMEUNIT.convert(maxTime, timeUnit);
        return this;
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public CountOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public String toString() {
        return "CountOptions{hint=" + this.hint + ", hintString='" + this.hintString + '\'' + ", limit=" + this.limit + ", skip=" + this.skip + ", maxTimeMS=" + this.maxTime + ", collation=" + this.collation + '}';
    }
}

