/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.lang.Nullable;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CreateCollectionOptionsConverter;
import io.vertx.ext.mongo.ValidationOptions;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

@DataObject(generateConverter=true)
public class CreateCollectionOptions {
    private long maxDocuments;
    private boolean capped;
    private long sizeInBytes;
    private JsonObject storageEngineOptions = new JsonObject();
    private JsonObject indexOptionDefaults = new JsonObject();
    private ValidationOptions validationOptions = new ValidationOptions();
    private CollationOptions collation;

    public CreateCollectionOptions() {
    }

    public CreateCollectionOptions(CreateCollectionOptions createCollectionOptions) {
        this.maxDocuments = createCollectionOptions.getMaxDocuments();
        this.capped = createCollectionOptions.isCapped();
        this.sizeInBytes = createCollectionOptions.getSizeInBytes();
        this.storageEngineOptions = createCollectionOptions.getStorageEngineOptions();
        this.indexOptionDefaults = createCollectionOptions.getIndexOptionDefaults();
        this.validationOptions = createCollectionOptions.getValidationOptions();
        this.collation = createCollectionOptions.getCollation();
    }

    public CreateCollectionOptions(JsonObject json) {
        CreateCollectionOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        CreateCollectionOptionsConverter.toJson(this, json);
        return json;
    }

    public long getMaxDocuments() {
        return this.maxDocuments;
    }

    public CreateCollectionOptions setMaxDocuments(long maxDocuments) {
        this.maxDocuments = maxDocuments;
        return this;
    }

    public com.mongodb.client.model.CreateCollectionOptions toMongoDriverObject() {
        return new com.mongodb.client.model.CreateCollectionOptions().collation(this.collation.toMongoDriverObject()).capped(this.capped).indexOptionDefaults(new IndexOptionDefaults().storageEngine((Bson)BsonDocument.parse((String)this.indexOptionDefaults.encode()))).validationOptions(this.validationOptions.toMongoDriverObject()).storageEngineOptions((Bson)BsonDocument.parse((String)this.storageEngineOptions.encode())).maxDocuments(this.maxDocuments).sizeInBytes(this.sizeInBytes);
    }

    public boolean isCapped() {
        return this.capped;
    }

    public CreateCollectionOptions setCapped(boolean capped) {
        this.capped = capped;
        return this;
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public CreateCollectionOptions setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        return this;
    }

    @Nullable
    public JsonObject getStorageEngineOptions() {
        return this.storageEngineOptions;
    }

    public CreateCollectionOptions setStorageEngineOptions(@Nullable JsonObject storageEngineOptions) {
        this.storageEngineOptions = storageEngineOptions;
        return this;
    }

    public JsonObject getIndexOptionDefaults() {
        return this.indexOptionDefaults;
    }

    public CreateCollectionOptions setIndexOptionDefaults(JsonObject indexOptionDefaults) {
        this.indexOptionDefaults = (JsonObject)Assertions.notNull((String)"indexOptionDefaults", (Object)indexOptionDefaults);
        return this;
    }

    public ValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    public CreateCollectionOptions setValidationOptions(ValidationOptions validationOptions) {
        this.validationOptions = (ValidationOptions)Assertions.notNull((String)"validationOptions", (Object)validationOptions);
        return this;
    }

    @Nullable
    public CollationOptions getCollation() {
        return this.collation;
    }

    public CreateCollectionOptions setCollation(@Nullable CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public String toString() {
        return "CreateCollectionOptions{, maxDocuments=" + this.maxDocuments + ", capped=" + this.capped + ", sizeInBytes=" + this.sizeInBytes + ", storageEngineOptions=" + this.storageEngineOptions + ", indexOptionDefaults=" + this.indexOptionDefaults + ", validationOptions=" + this.validationOptions + ", collation=" + this.collation + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCollectionOptions that = (CreateCollectionOptions)o;
        return this.getMaxDocuments() == that.getMaxDocuments() && this.isCapped() == that.isCapped() && this.getSizeInBytes() == that.getSizeInBytes() && Objects.equals(this.getStorageEngineOptions(), that.getStorageEngineOptions()) && Objects.equals(this.getIndexOptionDefaults(), that.getIndexOptionDefaults()) && Objects.equals(this.getValidationOptions(), that.getValidationOptions()) && Objects.equals(this.getCollation(), that.getCollation());
    }

    public int hashCode() {
        return Objects.hash(this.getMaxDocuments(), this.isCapped(), this.getSizeInBytes(), this.getStorageEngineOptions(), this.getIndexOptionDefaults(), this.getValidationOptions(), this.getCollation());
    }
}

