/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.MongoGridFsClient;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.MongoClientImpl;
import java.util.List;
import java.util.UUID;

@VertxGen
public interface MongoClient {
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public static MongoClient create(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, UUID.randomUUID().toString());
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config, String dataSourceName) {
        return new MongoClientImpl(vertx, config, dataSourceName);
    }

    public static MongoClient createShared(Vertx vertx, JsonObject config) {
        return new MongoClientImpl(vertx, config, DEFAULT_POOL_NAME);
    }

    @GenIgnore
    public static MongoClient createWithMongoSettings(Vertx vertx, JsonObject config, String dataSourceName, MongoClientSettings settings) {
        return new MongoClientImpl(vertx, config, dataSourceName, settings);
    }

    @Fluent
    public MongoClient save(String var1, JsonObject var2, Handler<AsyncResult<@Nullable String>> var3);

    public Future<@Nullable String> save(String var1, JsonObject var2);

    @Fluent
    public MongoClient saveWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<@Nullable String>> var4);

    public Future<@Nullable String> saveWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3);

    @Fluent
    public MongoClient insert(String var1, JsonObject var2, Handler<AsyncResult<@Nullable String>> var3);

    public Future<@Nullable String> insert(String var1, JsonObject var2);

    @Fluent
    public MongoClient insertWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<@Nullable String>> var4);

    public Future<@Nullable String> insertWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3);

    @Fluent
    public MongoClient updateCollection(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var4);

    public Future<@Nullable MongoClientUpdateResult> updateCollection(String var1, JsonObject var2, JsonObject var3);

    @Fluent
    public MongoClient updateCollection(String var1, JsonObject var2, JsonArray var3, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var4);

    public Future<@Nullable MongoClientUpdateResult> updateCollection(String var1, JsonObject var2, JsonArray var3);

    @Fluent
    public MongoClient updateCollectionWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var5);

    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4);

    @Fluent
    public MongoClient updateCollectionWithOptions(String var1, JsonObject var2, JsonArray var3, UpdateOptions var4, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var5);

    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String var1, JsonObject var2, JsonArray var3, UpdateOptions var4);

    @Fluent
    public MongoClient replaceDocuments(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var4);

    public Future<@Nullable MongoClientUpdateResult> replaceDocuments(String var1, JsonObject var2, JsonObject var3);

    @Fluent
    public MongoClient replaceDocumentsWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> var5);

    public Future<@Nullable MongoClientUpdateResult> replaceDocumentsWithOptions(String var1, JsonObject var2, JsonObject var3, UpdateOptions var4);

    @Fluent
    public MongoClient bulkWrite(String var1, List<BulkOperation> var2, Handler<AsyncResult<@Nullable MongoClientBulkWriteResult>> var3);

    public Future<@Nullable MongoClientBulkWriteResult> bulkWrite(String var1, List<BulkOperation> var2);

    @Fluent
    public MongoClient bulkWriteWithOptions(String var1, List<BulkOperation> var2, BulkWriteOptions var3, Handler<AsyncResult<@Nullable MongoClientBulkWriteResult>> var4);

    public Future<@Nullable MongoClientBulkWriteResult> bulkWriteWithOptions(String var1, List<BulkOperation> var2, BulkWriteOptions var3);

    @Fluent
    public MongoClient find(String var1, JsonObject var2, Handler<AsyncResult<List<JsonObject>>> var3);

    public Future<List<JsonObject>> find(String var1, JsonObject var2);

    public ReadStream<JsonObject> findBatch(String var1, JsonObject var2);

    @Fluent
    public MongoClient findWithOptions(String var1, JsonObject var2, FindOptions var3, Handler<AsyncResult<List<JsonObject>>> var4);

    public Future<List<JsonObject>> findWithOptions(String var1, JsonObject var2, FindOptions var3);

    public ReadStream<JsonObject> findBatchWithOptions(String var1, JsonObject var2, FindOptions var3);

    @Fluent
    public MongoClient findOne(String var1, JsonObject var2, @Nullable JsonObject var3, Handler<AsyncResult<@Nullable JsonObject>> var4);

    public Future<@Nullable JsonObject> findOne(String var1, JsonObject var2, @Nullable JsonObject var3);

    @Fluent
    public MongoClient findOneAndUpdate(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<@Nullable JsonObject>> var4);

    public Future<@Nullable JsonObject> findOneAndUpdate(String var1, JsonObject var2, JsonObject var3);

    @Fluent
    public MongoClient findOneAndUpdateWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5, Handler<AsyncResult<@Nullable JsonObject>> var6);

    public Future<@Nullable JsonObject> findOneAndUpdateWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5);

    @Fluent
    public MongoClient findOneAndReplace(String var1, JsonObject var2, JsonObject var3, Handler<AsyncResult<@Nullable JsonObject>> var4);

    public Future<@Nullable JsonObject> findOneAndReplace(String var1, JsonObject var2, JsonObject var3);

    @Fluent
    public MongoClient findOneAndReplaceWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5, Handler<AsyncResult<@Nullable JsonObject>> var6);

    public Future<@Nullable JsonObject> findOneAndReplaceWithOptions(String var1, JsonObject var2, JsonObject var3, FindOptions var4, UpdateOptions var5);

    @Fluent
    public MongoClient findOneAndDelete(String var1, JsonObject var2, Handler<AsyncResult<@Nullable JsonObject>> var3);

    public Future<@Nullable JsonObject> findOneAndDelete(String var1, JsonObject var2);

    @Fluent
    public MongoClient findOneAndDeleteWithOptions(String var1, JsonObject var2, FindOptions var3, Handler<AsyncResult<@Nullable JsonObject>> var4);

    public Future<@Nullable JsonObject> findOneAndDeleteWithOptions(String var1, JsonObject var2, FindOptions var3);

    @Fluent
    public MongoClient count(String var1, JsonObject var2, Handler<AsyncResult<Long>> var3);

    public Future<Long> count(String var1, JsonObject var2);

    @Fluent
    public MongoClient countWithOptions(String var1, JsonObject var2, CountOptions var3, Handler<AsyncResult<Long>> var4);

    public Future<Long> countWithOptions(String var1, JsonObject var2, CountOptions var3);

    @Fluent
    public MongoClient removeDocuments(String var1, JsonObject var2, Handler<AsyncResult<@Nullable MongoClientDeleteResult>> var3);

    public Future<@Nullable MongoClientDeleteResult> removeDocuments(String var1, JsonObject var2);

    @Fluent
    public MongoClient removeDocumentsWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<@Nullable MongoClientDeleteResult>> var4);

    public Future<@Nullable MongoClientDeleteResult> removeDocumentsWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3);

    @Fluent
    public MongoClient removeDocument(String var1, JsonObject var2, Handler<AsyncResult<@Nullable MongoClientDeleteResult>> var3);

    public Future<@Nullable MongoClientDeleteResult> removeDocument(String var1, JsonObject var2);

    @Fluent
    public MongoClient removeDocumentWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3, Handler<AsyncResult<@Nullable MongoClientDeleteResult>> var4);

    public Future<@Nullable MongoClientDeleteResult> removeDocumentWithOptions(String var1, JsonObject var2, @Nullable WriteOption var3);

    @Fluent
    public MongoClient createCollection(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MongoClient createCollectionWithOptions(String var1, CreateCollectionOptions var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> createCollection(String var1);

    public Future<Void> createCollectionWithOptions(String var1, CreateCollectionOptions var2);

    @Fluent
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> var1);

    public Future<List<String>> getCollections();

    @Fluent
    public MongoClient dropCollection(String var1, Handler<AsyncResult<Void>> var2);

    public Future<Void> dropCollection(String var1);

    @Fluent
    public MongoClient createIndex(String var1, JsonObject var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> createIndex(String var1, JsonObject var2);

    @Fluent
    public MongoClient createIndexWithOptions(String var1, JsonObject var2, IndexOptions var3, Handler<AsyncResult<Void>> var4);

    public Future<Void> createIndexWithOptions(String var1, JsonObject var2, IndexOptions var3);

    @Fluent
    public MongoClient createIndexes(String var1, List<IndexModel> var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> createIndexes(String var1, List<IndexModel> var2);

    @Fluent
    public MongoClient listIndexes(String var1, Handler<AsyncResult<JsonArray>> var2);

    public Future<JsonArray> listIndexes(String var1);

    @Fluent
    public MongoClient dropIndex(String var1, String var2, Handler<AsyncResult<Void>> var3);

    public Future<Void> dropIndex(String var1, String var2);

    @Fluent
    public MongoClient runCommand(String var1, JsonObject var2, Handler<AsyncResult<@Nullable JsonObject>> var3);

    public Future<@Nullable JsonObject> runCommand(String var1, JsonObject var2);

    @Fluent
    public MongoClient distinct(String var1, String var2, String var3, Handler<AsyncResult<JsonArray>> var4);

    @Fluent
    public MongoClient distinct(String var1, String var2, String var3, Handler<AsyncResult<JsonArray>> var4, DistinctOptions var5);

    public Future<JsonArray> distinct(String var1, String var2, String var3);

    public Future<JsonArray> distinct(String var1, String var2, String var3, DistinctOptions var4);

    @Fluent
    public MongoClient distinctWithQuery(String var1, String var2, String var3, JsonObject var4, Handler<AsyncResult<JsonArray>> var5);

    @Fluent
    public MongoClient distinctWithQuery(String var1, String var2, String var3, JsonObject var4, Handler<AsyncResult<JsonArray>> var5, DistinctOptions var6);

    public Future<JsonArray> distinctWithQuery(String var1, String var2, String var3, JsonObject var4);

    public Future<JsonArray> distinctWithQuery(String var1, String var2, String var3, JsonObject var4, DistinctOptions var5);

    public ReadStream<JsonObject> distinctBatch(String var1, String var2, String var3);

    public ReadStream<JsonObject> distinctBatch(String var1, String var2, String var3, DistinctOptions var4);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4, DistinctOptions var5);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4, int var5);

    public ReadStream<JsonObject> distinctBatchWithQuery(String var1, String var2, String var3, JsonObject var4, int var5, DistinctOptions var6);

    public ReadStream<JsonObject> aggregate(String var1, JsonArray var2);

    public ReadStream<JsonObject> aggregateWithOptions(String var1, JsonArray var2, AggregateOptions var3);

    @GenIgnore(value={"permitted-type"})
    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String var1, JsonArray var2, boolean var3, int var4);

    @Fluent
    public MongoClient createDefaultGridFsBucketService(Handler<AsyncResult<MongoGridFsClient>> var1);

    public Future<MongoGridFsClient> createDefaultGridFsBucketService();

    @Fluent
    public MongoClient createGridFsBucketService(String var1, Handler<AsyncResult<MongoGridFsClient>> var2);

    public Future<MongoGridFsClient> createGridFsBucketService(String var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);
}

