/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.MongoClientSettings;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSBuckets;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.MongoGridFsClient;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.BufferingSubscriber;
import io.vertx.ext.mongo.impl.CompletionSubscriber;
import io.vertx.ext.mongo.impl.FailedStream;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.MappingAndBufferingSubscriber;
import io.vertx.ext.mongo.impl.MappingStream;
import io.vertx.ext.mongo.impl.MongoGridFsClientImpl;
import io.vertx.ext.mongo.impl.PublisherAdapter;
import io.vertx.ext.mongo.impl.SingleResultSubscriber;
import io.vertx.ext.mongo.impl.Utils;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public class MongoClientImpl
implements MongoClient,
Closeable {
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final AggregateOptions DEFAULT_AGGREGATE_OPTIONS = new AggregateOptions();
    private static final BulkWriteOptions DEFAULT_BULK_WRITE_OPTIONS = new BulkWriteOptions();
    private static final String DS_LOCAL_MAP_NAME = "__vertx.MongoClient.datasources";
    public static final String COLLECTION_CANNOT_BE_NULL = "collection cannot be null";
    public static final String QUERY_CANNOT_BE_NULL = "query cannot be null";
    public static final String FIELD_NAME_CANNOT_BE_NULL = "fieldName cannot be null";
    public static final String UPDATE_CANNOT_BE_NULL = "update cannot be null";
    public static final String OPTIONS_CANNOT_BE_NULL = "options cannot be null";
    public static final String PIPELINE_CANNOT_BE_NULL = "pipeline cannot be null";
    public static final String FIND_OPTIONS_CANNOT_BE_NULL = "find options cannot be null";
    private final VertxInternal vertx;
    private final ContextInternal creatingContext;
    protected com.mongodb.reactivestreams.client.MongoClient mongo;
    private final MongoHolder holder;
    private final boolean useObjectId;

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        this.vertx = (VertxInternal)vertx;
        this.creatingContext = this.vertx.getOrCreateContext();
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo(vertx);
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
        this.creatingContext.addCloseHook((Closeable)this);
    }

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName, MongoClientSettings settings) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        Objects.requireNonNull(settings);
        this.vertx = (VertxInternal)vertx;
        this.creatingContext = this.vertx.getOrCreateContext();
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo(vertx, settings);
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
        this.creatingContext.addCloseHook((Closeable)this);
    }

    @GenIgnore
    public static <T> DistinctPublisher<T> setDistinctOptions(DistinctPublisher<T> distinctPublisher, DistinctOptions distinctOptions) {
        if (distinctOptions != null && distinctOptions.getCollation() != null) {
            distinctPublisher.collation(distinctOptions.getCollation().toMongoDriverObject());
        }
        return distinctPublisher;
    }

    public void close(Promise<Void> completionHandler) {
        this.holder.close();
        completionHandler.complete();
    }

    @Override
    public Future<Void> close() {
        this.holder.close();
        this.creatingContext.removeCloseHook((Closeable)this);
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    @Override
    public MongoClient save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        Future<String> future = this.save(collection, document);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable String> save(String collection, JsonObject document) {
        return this.saveWithOptions(collection, document, null);
    }

    @Override
    public MongoClient saveWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Future<String> future = this.saveWithOptions(collection, document, writeOption);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable String> saveWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(document, "document cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        Object id = document.getValue("_id");
        if (id == null) {
            PromiseInternal promise = this.vertx.promise();
            coll.insertOne((Object)document).subscribe(new CompletionSubscriber((Promise<Void>)promise));
            return promise.future().map(v -> this.useObjectId ? document.getJsonObject("_id").getString("$oid") : document.getString("_id"));
        }
        JsonObject filter = new JsonObject();
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        filter.put("_id", encodedDocument.getValue("_id"));
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        PromiseInternal promise = this.vertx.promise();
        coll.replaceOne((Bson)this.wrap(filter), (Object)encodedDocument, replaceOptions).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future().mapEmpty();
    }

    @Override
    public MongoClient insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        Future<String> future = this.insert(collection, document);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable String> insert(String collection, JsonObject document) {
        return this.insertWithOptions(collection, document, null);
    }

    @Override
    public MongoClient insertWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Future<String> future = this.insertWithOptions(collection, document, writeOption);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable String> insertWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(document, "document cannot be null");
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        boolean hasCustomId = document.containsKey("_id");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        PromiseInternal promise = this.vertx.promise();
        coll.insertOne((Object)encodedDocument).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future().map(v -> hasCustomId ? null : this.decodeKeyWhenUseObjectId(encodedDocument).getString("_id"));
    }

    @Override
    public MongoClient updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.updateCollection(collection, query, update);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) {
        return this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public MongoClient updateCollection(String collection, JsonObject query, JsonArray update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.updateCollection(collection, query, update);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) {
        return this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.updateCollectionWithOptions(collection, query, update, options);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(update, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        JsonObjectBsonAdapter bupdate = this.wrap(this.encodeKeyWhenUseObjectId(this.generateIdIfNeeded(query, update, options)));
        com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
        if (options.getArrayFilters() != null && !options.getArrayFilters().isEmpty()) {
            ArrayList bArrayFilters = new ArrayList(options.getArrayFilters().size());
            options.getArrayFilters().getList().forEach(entry -> bArrayFilters.add(this.wrap(JsonObject.mapFrom((Object)entry))));
            updateOptions.arrayFilters(bArrayFilters);
        }
        if (options.getCollation() != null) {
            updateOptions.collation(options.getCollation().toMongoDriverObject());
        }
        Publisher publisher = options.isMulti() ? coll.updateMany((Bson)bquery, (Bson)bupdate, updateOptions) : coll.updateOne((Bson)bquery, (Bson)bupdate, updateOptions);
        PromiseInternal promise = this.vertx.promise();
        publisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    @Override
    public MongoClient updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options, Handler<AsyncResult<@Nullable MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.updateCollectionWithOptions(collection, query, update, options);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray pipeline, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        ArrayList<JsonObjectBsonAdapter> bpipeline = new ArrayList<JsonObjectBsonAdapter>(pipeline.size());
        for (int i = 0; i < pipeline.size(); ++i) {
            bpipeline.add(this.wrap(pipeline.getJsonObject(i)));
        }
        com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
        if (options.getArrayFilters() != null && !options.getArrayFilters().isEmpty()) {
            ArrayList bArrayFilters = new ArrayList(options.getArrayFilters().size());
            options.getArrayFilters().getList().forEach(entry -> bArrayFilters.add(this.wrap(JsonObject.mapFrom((Object)entry))));
            updateOptions.arrayFilters(bArrayFilters);
        }
        if (options.getCollation() != null) {
            updateOptions.collation(options.getCollation().toMongoDriverObject());
        }
        Publisher publisher = coll.updateMany((Bson)bquery, bpipeline, updateOptions);
        PromiseInternal promise = this.vertx.promise();
        publisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    private JsonObject generateIdIfNeeded(JsonObject query, JsonObject update, UpdateOptions options) {
        if (options.isUpsert() && !update.containsKey("_id") && !this.useObjectId) {
            JsonObject setId = update.getJsonObject("$setOnInsert", new JsonObject());
            String id = query.containsKey("_id") ? query.getString("_id") : JsonObjectCodec.generateHexObjectId();
            setId.put("_id", (Object)id);
            update.put("$setOnInsert", (Object)setId);
        }
        return update;
    }

    @Override
    public MongoClient replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.replaceDocumentsWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return this.replaceDocumentsWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public MongoClient replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        Future<MongoClientUpdateResult> future = this.replaceDocumentsWithOptions(collection, query, replace, options);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(replace, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(options.isUpsert());
        if (options.getCollation() != null) {
            replaceOptions.collation(options.getCollation().toMongoDriverObject());
        }
        PromiseInternal promise = this.vertx.promise();
        coll.replaceOne((Bson)bquery, (Object)this.encodeKeyWhenUseObjectId(replace), replaceOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    @Override
    public MongoClient find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Future<List<JsonObject>> future = this.find(collection, query);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<List<JsonObject>> find(String collection, JsonObject query) {
        return this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public MongoClient findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Future<List<JsonObject>> future = this.findWithOptions(collection, query, options);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<List<JsonObject>> findWithOptions(String collection, JsonObject query, FindOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        PromiseInternal promise = this.vertx.promise();
        this.doFind(collection, this.encodeKeyWhenUseObjectId(query), options).subscribe(new MappingAndBufferingSubscriber<JsonObject, JsonObject>(this::decodeKeyWhenUseObjectId, (Promise<List<JsonObject>>)promise));
        return promise.future();
    }

    @Override
    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        return this.findBatchWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        FindPublisher<JsonObject> view = this.doFind(collection, query, options);
        return new PublisherAdapter<JsonObject>(this.vertx.getOrCreateContext(), (Publisher<JsonObject>)view, options.getBatchSize());
    }

    @Override
    public MongoClient findOne(String collection, JsonObject query, @Nullable JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOne(collection, query, fields);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOne(String collection, JsonObject query, @Nullable JsonObject fields) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bfields = this.wrap(fields);
        PromiseInternal promise = this.vertx.promise();
        this.getCollection(collection).find((Bson)bquery).projection((Bson)bfields).first().subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(object -> object == null ? null : this.decodeKeyWhenUseObjectId((JsonObject)object));
    }

    @Override
    public MongoClient findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndUpdate(collection, query, update);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return this.findOneAndUpdateWithOptions(collection, query, update, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public MongoClient findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(update, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bupdate = this.wrap(update);
        FindOneAndUpdateOptions foauOptions = new FindOneAndUpdateOptions();
        foauOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foauOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foauOptions.upsert(updateOptions.isUpsert());
        foauOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        if (updateOptions.getArrayFilters() != null && !updateOptions.getArrayFilters().isEmpty()) {
            ArrayList bArrayFilters = new ArrayList(updateOptions.getArrayFilters().size());
            updateOptions.getArrayFilters().getList().forEach(entry -> bArrayFilters.add(this.wrap(JsonObject.mapFrom((Object)entry))));
            foauOptions.arrayFilters(bArrayFilters);
        }
        if (findOptions.getCollation() != null) {
            foauOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        if (updateOptions.getCollation() != null) {
            foauOptions.collation(updateOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndUpdate((Bson)bquery, (Bson)bupdate, foauOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndReplace(collection, query, replace);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return this.findOneAndReplaceWithOptions(collection, query, replace, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public MongoClient findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndReplaceOptions foarOptions = new FindOneAndReplaceOptions();
        foarOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foarOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foarOptions.upsert(updateOptions.isUpsert());
        foarOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        if (findOptions.getCollation() != null) {
            foarOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndReplace((Bson)bquery, (Object)replace, foarOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndDelete(collection, query);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndDelete(String collection, JsonObject query) {
        return this.findOneAndDeleteWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public MongoClient findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.findOneAndDeleteWithOptions(collection, query, findOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndDeleteOptions foadOptions = new FindOneAndDeleteOptions();
        foadOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foadOptions.projection((Bson)this.wrap(findOptions.getFields()));
        if (findOptions.getCollation() != null) {
            foadOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndDelete((Bson)bquery, foadOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        Future<Long> future = this.countWithOptions(collection, query, null);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public MongoClient countWithOptions(String collection, JsonObject query, CountOptions countOptions, Handler<AsyncResult<Long>> resultHandler) {
        Future<Long> future = this.countWithOptions(collection, query, countOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Long> count(String collection, JsonObject query) {
        return this.countWithOptions(collection, query, null);
    }

    @Override
    public Future<Long> countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        Publisher countPublisher = countOptions != null ? coll.countDocuments((Bson)bquery, countOptions.toMongoDriverObject()) : coll.countDocuments((Bson)bquery);
        countPublisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Future<MongoClientDeleteResult> future = this.removeDocuments(collection, query);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) {
        return this.removeDocumentsWithOptions(collection, query, null);
    }

    @Override
    public MongoClient removeDocumentsWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Future<MongoClientDeleteResult> future = this.removeDocumentsWithOptions(collection, query, writeOption);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        PromiseInternal promise = this.vertx.promise();
        coll.deleteMany((Bson)bquery).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientDeleteResult);
    }

    @Override
    public MongoClient removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Future<MongoClientDeleteResult> future = this.removeDocument(collection, query);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocument(String collection, JsonObject query) {
        return this.removeDocumentWithOptions(collection, query, null);
    }

    @Override
    public MongoClient removeDocumentWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        Future<MongoClientDeleteResult> future = this.removeDocumentWithOptions(collection, query, writeOption);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        PromiseInternal promise = this.vertx.promise();
        coll.deleteOne((Bson)bquery).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientDeleteResult);
    }

    @Override
    public MongoClient bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        Future<MongoClientBulkWriteResult> future = this.bulkWrite(collection, operations);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientBulkWriteResult> bulkWrite(String collection, List<BulkOperation> operations) {
        return this.bulkWriteWithOptions(collection, operations, DEFAULT_BULK_WRITE_OPTIONS);
    }

    @Override
    public MongoClient bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        Future<MongoClientBulkWriteResult> future = this.bulkWriteWithOptions(collection, operations, bulkWriteOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(operations, "operations cannot be null");
        Objects.requireNonNull(bulkWriteOptions, "bulkWriteOptions cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, bulkWriteOptions.getWriteOption());
        List<WriteModel<JsonObject>> bulkOperations = this.convertBulkOperations(operations);
        com.mongodb.client.model.BulkWriteOptions options = new com.mongodb.client.model.BulkWriteOptions().ordered(bulkWriteOptions.isOrdered());
        PromiseInternal promise = this.vertx.promise();
        coll.bulkWrite(bulkOperations, options).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientBulkWriteResult);
    }

    private List<WriteModel<JsonObject>> convertBulkOperations(List<BulkOperation> operations) {
        ArrayList<WriteModel<JsonObject>> result = new ArrayList<WriteModel<JsonObject>>(operations.size());
        block6: for (BulkOperation bulkOperation : operations) {
            switch (bulkOperation.getType()) {
                case DELETE: {
                    Bson bsonFilter = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    DeleteOptions deleteOptions = new DeleteOptions();
                    if (bulkOperation.getCollation() != null) {
                        deleteOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new DeleteManyModel(bsonFilter, deleteOptions));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new DeleteOneModel(bsonFilter, deleteOptions));
                    continue block6;
                }
                case INSERT: {
                    result.add((WriteModel<JsonObject>)new InsertOneModel((Object)this.encodeKeyWhenUseObjectId(bulkOperation.getDocument())));
                    continue block6;
                }
                case REPLACE: {
                    ReplaceOptions replaceOptions = new ReplaceOptions();
                    if (bulkOperation.getCollation() != null) {
                        replaceOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    result.add((WriteModel<JsonObject>)new ReplaceOneModel(MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter())), (Object)bulkOperation.getDocument(), replaceOptions.upsert(bulkOperation.isUpsert())));
                    continue block6;
                }
                case UPDATE: {
                    Bson filter = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    Bson document = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getDocument()));
                    com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(bulkOperation.isUpsert());
                    if (bulkOperation.getCollation() != null) {
                        updateOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new UpdateManyModel(filter, document, updateOptions));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new UpdateOneModel(filter, document, updateOptions));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown bulk operation type: " + bulkOperation.getClass());
        }
        return result;
    }

    @Override
    public MongoClient createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.createCollection(collectionName);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public MongoClient createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.createCollectionWithOptions(collectionName, collectionOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> createCollection(String collectionName) {
        Objects.requireNonNull(collectionName, "collectionName cannot be null");
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.createCollection(collectionName).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        Objects.requireNonNull(collectionName, "collectionName cannot be null");
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.createCollection(collectionName, collectionOptions.toMongoDriverObject()).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public MongoClient getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        Future<List<String>> future = this.getCollections();
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<List<String>> getCollections() {
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.listCollectionNames().subscribe(new BufferingSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.dropCollection(collection);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> dropCollection(String collection) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.drop().subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public MongoClient createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.createIndex(collection, key);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> createIndex(String collection, JsonObject key) {
        return this.createIndexWithOptions(collection, key, new IndexOptions());
    }

    @Override
    public MongoClient createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.createIndexWithOptions(collection, key, options);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(key, FIELD_NAME_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        com.mongodb.client.model.IndexOptions driverOpts = this.mongoIndexOptions(options);
        PromiseInternal promise = this.vertx.promise();
        coll.createIndex((Bson)this.wrap(key), driverOpts).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public MongoClient createIndexes(String collection, List<IndexModel> indexes, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.createIndexes(collection, indexes);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> createIndexes(String collection, List<IndexModel> indexes) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        List transformIndexes = indexes.stream().map(it -> {
            if (it.getOptions() != null) {
                return new com.mongodb.client.model.IndexModel((Bson)this.wrap(it.getKey()), this.mongoIndexOptions(it.getOptions()));
            }
            return new com.mongodb.client.model.IndexModel((Bson)this.wrap(it.getKey()));
        }).collect(Collectors.toList());
        PromiseInternal promise = this.vertx.promise();
        this.getCollection(collection).createIndexes(transformIndexes).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    private static Bson toBson(@Nullable JsonObject json) {
        return json == null ? null : BsonDocument.parse((String)json.encode());
    }

    @Override
    public MongoClient listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        Future<JsonArray> future = this.listIndexes(collection);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<JsonArray> listIndexes(String collection) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.listIndexes(JsonObject.class).subscribe(new BufferingSubscriber(promise));
        return promise.future().map(JsonArray::new);
    }

    @Override
    public MongoClient dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        Future<Void> future = this.dropIndex(collection, indexName);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<Void> dropIndex(String collection, String indexName) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(indexName, "indexName cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.dropIndex(indexName).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public MongoClient runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        Future<JsonObject> future = this.runCommand(commandName, command);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<@Nullable JsonObject> runCommand(String commandName, JsonObject command) {
        Objects.requireNonNull(commandName, "commandName cannot be null");
        Objects.requireNonNull(command, "command cannot be null");
        JsonObject json = new JsonObject();
        Object commandVal = command.getValue(commandName);
        if (commandVal == null) {
            throw new IllegalArgumentException("commandBody does not contain key for " + commandName);
        }
        json.put(commandName, commandVal);
        command.forEach(entry -> {
            if (!((String)entry.getKey()).equals(commandName)) {
                json.put((String)entry.getKey(), entry.getValue());
            }
        });
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.runCommand((Bson)this.wrap(json), JsonObject.class).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public MongoClient distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        return this.distinct(collection, fieldName, resultClassname, null, resultHandler);
    }

    @Override
    public MongoClient distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions, Handler<AsyncResult<JsonArray>> resultHandler) {
        Future<JsonArray> future = this.distinct(collection, fieldName, resultClassname, distinctOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname) {
        return this.distinct(collection, fieldName, resultClassname, (DistinctOptions)null);
    }

    @Override
    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, new JsonObject(), distinctOptions);
    }

    @Override
    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, query, null, resultHandler);
    }

    @Override
    public MongoClient distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions, Handler<AsyncResult<JsonArray>> resultHandler) {
        Future<JsonArray> future = this.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions);
        Utils.setHandler(future, resultHandler);
        return this;
    }

    @Override
    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, query, (DistinctOptions)null);
    }

    @Override
    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        try {
            PromiseInternal promise = this.vertx.promise();
            this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query, distinctOptions).subscribe(new BufferingSubscriber(promise));
            return promise.future().map(JsonArray::new);
        }
        catch (ClassNotFoundException e) {
            return this.vertx.getOrCreateContext().failedFuture((Throwable)e);
        }
    }

    @Override
    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        return this.distinctBatch(collection, fieldName, resultClassname, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, new JsonObject(), distinctOptions);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, 20, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        try {
            DistinctPublisher<?> distinctValuesWithQuery = this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query, distinctOptions);
            PublisherAdapter readStream = new PublisherAdapter(this.vertx.getOrCreateContext(), (Publisher<?>)distinctValuesWithQuery, batchSize);
            return new MappingStream<Object, JsonObject>(readStream, value -> new JsonObject().put(fieldName, value));
        }
        catch (ClassNotFoundException e) {
            return new FailedStream(e);
        }
    }

    @Override
    public MongoClient createDefaultGridFsBucketService(Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        return this.createGridFsBucketService("fs", resultHandler);
    }

    @Override
    public Future<MongoGridFsClient> createDefaultGridFsBucketService() {
        Promise promise = Promise.promise();
        this.createDefaultGridFsBucketService((Handler<AsyncResult<MongoGridFsClient>>)promise);
        return promise.future();
    }

    @Override
    public MongoClient createGridFsBucketService(String bucketName, Handler<AsyncResult<MongoGridFsClient>> resultHandler) {
        MongoGridFsClientImpl impl = new MongoGridFsClientImpl(this.vertx, this, this.getGridFSBucket(bucketName));
        resultHandler.handle((Object)Future.succeededFuture((Object)impl));
        return this;
    }

    @Override
    public Future<MongoGridFsClient> createGridFsBucketService(String bucketName) {
        Promise promise = Promise.promise();
        this.createGridFsBucketService(bucketName, (Handler<AsyncResult<MongoGridFsClient>>)promise);
        return promise.future();
    }

    private GridFSBucket getGridFSBucket(String bucketName) {
        return GridFSBuckets.create((MongoDatabase)this.holder.db, (String)bucketName);
    }

    @Override
    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        return this.aggregateWithOptions(collection, pipeline, DEFAULT_AGGREGATE_OPTIONS);
    }

    @Override
    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        AggregatePublisher<JsonObject> view = this.doAggregate(collection, pipeline, options);
        return new PublisherAdapter<JsonObject>(this.vertx.getOrCreateContext(), (Publisher<JsonObject>)view, options.getBatchSize());
    }

    @Override
    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ArrayList bpipeline = new ArrayList(pipeline.size());
        pipeline.getList().forEach(entry -> bpipeline.add(this.wrap(JsonObject.mapFrom((Object)entry))));
        ChangeStreamPublisher changeStreamPublisher = coll.watch(bpipeline, JsonObject.class);
        if (withUpdatedDoc) {
            changeStreamPublisher.fullDocument(FullDocument.UPDATE_LOOKUP);
        }
        if (batchSize < 1) {
            batchSize = 1;
        }
        return new PublisherAdapter<ChangeStreamDocument<JsonObject>>(this.vertx.getOrCreateContext(), (Publisher<ChangeStreamDocument<JsonObject>>)changeStreamPublisher, batchSize);
    }

    private DistinctPublisher<?> findDistinctValuesWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) throws ClassNotFoundException {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.encodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        MongoCollection<JsonObject> mongoCollection = this.getCollection(collection);
        Class<?> resultClass = this.getClass().getClassLoader().loadClass(resultClassname);
        return MongoClientImpl.setDistinctOptions(mongoCollection.distinct(fieldName, (Bson)bquery, resultClass), distinctOptions);
    }

    private AggregatePublisher<JsonObject> doAggregate(String collection, JsonArray pipeline, AggregateOptions aggregateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        Objects.requireNonNull(aggregateOptions, "aggregateOptions cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ArrayList bpipeline = new ArrayList(pipeline.size());
        pipeline.getList().forEach(entry -> bpipeline.add(this.wrap(JsonObject.mapFrom((Object)entry))));
        AggregatePublisher aggregate = coll.aggregate(bpipeline, JsonObject.class);
        if (aggregateOptions.getCollation() != null) {
            aggregate.collation(aggregateOptions.getCollation().toMongoDriverObject());
        }
        if (aggregateOptions.getBatchSize() != -1) {
            aggregate.batchSize(aggregateOptions.getBatchSize());
        }
        if (aggregateOptions.getMaxTime() > 0L) {
            aggregate.maxTime(aggregateOptions.getMaxTime(), TimeUnit.MILLISECONDS);
        }
        if (aggregateOptions.getAllowDiskUse() != null) {
            aggregate.allowDiskUse(aggregateOptions.getAllowDiskUse());
        }
        return aggregate;
    }

    JsonObject encodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idString = json.getValue("_id", null);
        if (idString instanceof String && ObjectId.isValid((String)((String)idString))) {
            json.put("_id", (Object)new JsonObject().put("$oid", idString));
        }
        return json;
    }

    private JsonObject decodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idField = json.getValue("_id", null);
        if (!(idField instanceof JsonObject)) {
            return json;
        }
        Object idString = ((JsonObject)idField).getValue("$oid", null);
        if (!(idString instanceof String)) {
            return json;
        }
        json.put("_id", idString);
        return json;
    }

    private FindPublisher<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        JsonObjectBsonAdapter bquery = this.wrap(this.encodeKeyWhenUseObjectId(query));
        FindPublisher find = coll.find((Bson)bquery, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Bson)this.wrap(options.getSort()));
        }
        if (options.getFields() != null) {
            find.projection((Bson)this.wrap(options.getFields()));
        }
        if (options.getHint() != null && !options.getHint().isEmpty()) {
            find.hintString(options.getHint());
        }
        if (options.getCollation() != null) {
            find.collation(options.getCollation().toMongoDriverObject());
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, @Nullable WriteOption writeOption) {
        MongoCollection coll = this.holder.db.getCollection(name, JsonObject.class);
        if (coll != null && writeOption != null) {
            coll = coll.withWriteConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return coll;
    }

    private com.mongodb.client.model.IndexOptions mongoIndexOptions(IndexOptions options) {
        CollationOptions co = options.getCollation();
        com.mongodb.client.model.IndexOptions o = new com.mongodb.client.model.IndexOptions().background(options.isBackground()).unique(options.isUnique()).name(options.getName()).sparse(options.isSparse()).expireAfter(options.getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(options.getVersion()).weights(MongoClientImpl.toBson(options.getWeights())).defaultLanguage(options.getDefaultLanguage()).languageOverride(options.getLanguageOverride()).textVersion(options.getTextVersion()).sphereVersion(options.getSphereVersion()).bits(options.getBits()).min(options.getMin()).max(options.getMax()).bucketSize(options.getBucketSize()).storageEngine(MongoClientImpl.toBson(options.getStorageEngine())).partialFilterExpression(MongoClientImpl.toBson(options.getPartialFilterExpression()));
        if (co != null) {
            o.collation(co.toMongoDriverObject());
        }
        return o;
    }

    @Nullable JsonObjectBsonAdapter wrap(@Nullable JsonObject jsonObject) {
        return jsonObject == null ? null : new JsonObjectBsonAdapter(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MongoHolder> map, String dataSourceName) {
        VertxInternal vertxInternal = this.vertx;
        synchronized (vertxInternal) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoHolder lookupHolder(String datasourceName, JsonObject config) {
        VertxInternal vertxInternal = this.vertx;
        synchronized (vertxInternal) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            MongoHolder theHolder = (MongoHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new MongoHolder(config, () -> this.removeFromMap((LocalMap<String, MongoHolder>)map, datasourceName));
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.close((Promise<Void>)ctx.promise(handler));
    }

    private static class MongoHolder
    implements Shareable {
        com.mongodb.reactivestreams.client.MongoClient mongo;
        MongoDatabase db;
        JsonObject config;
        Runnable closeRunner;
        int refCount = 1;

        MongoHolder(JsonObject config, Runnable closeRunner) {
            this.config = config;
            this.closeRunner = closeRunner;
        }

        synchronized com.mongodb.reactivestreams.client.MongoClient mongo(Vertx vertx) {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(vertx, this.config);
                this.mongo = MongoClients.create((MongoClientSettings)parser.settings());
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized com.mongodb.reactivestreams.client.MongoClient mongo(Vertx vertx, MongoClientSettings settings) {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(vertx, this.config);
                this.mongo = MongoClients.create((MongoClientSettings)settings);
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        synchronized void close() {
            if (--this.refCount == 0) {
                if (this.mongo != null) {
                    this.mongo.close();
                }
                if (this.closeRunner != null) {
                    this.closeRunner.run();
                }
            }
        }
    }
}

