/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.FindOptionsConverter;
import java.util.Map;
import java.util.Objects;

@DataObject(generateConverter=true)
public class FindOptions {
    public static final int DEFAULT_LIMIT = -1;
    public static final int DEFAULT_SKIP = 0;
    public static final int DEFAULT_BATCH_SIZE = 20;
    private JsonObject fields;
    private JsonObject sort;
    private int limit;
    private int skip;
    private int batchSize;
    private String hint;
    private CollationOptions collation;

    public FindOptions() {
        this.fields = new JsonObject();
        this.sort = new JsonObject();
        this.limit = -1;
        this.skip = 0;
        this.batchSize = 20;
    }

    public FindOptions(FindOptions options) {
        this.fields = options.fields != null ? options.fields.copy() : new JsonObject();
        this.sort = options.sort != null ? options.sort.copy() : new JsonObject();
        this.limit = options.limit;
        this.skip = options.skip;
        this.batchSize = options.batchSize;
        this.hint = options.hint;
        this.collation = options.getCollation();
    }

    public FindOptions(JsonObject options) {
        this();
        FindOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)options, this);
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public FindOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        FindOptionsConverter.toJson(this, json);
        return json;
    }

    public JsonObject getFields() {
        return this.fields;
    }

    public FindOptions setFields(JsonObject fields) {
        this.fields = fields;
        return this;
    }

    public JsonObject getSort() {
        return this.sort;
    }

    public FindOptions setSort(JsonObject sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions setSkip(int skip) {
        this.skip = skip;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOptions setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public String getHint() {
        return this.hint;
    }

    public FindOptions setHint(String hint) {
        this.hint = hint;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindOptions that = (FindOptions)o;
        return this.limit == that.limit && this.skip == that.skip && this.batchSize == that.batchSize && Objects.equals(this.fields, that.fields) && Objects.equals(this.sort, that.sort) && Objects.equals(this.hint, that.hint) && Objects.equals(this.collation, that.collation);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.sort, this.limit, this.skip, this.batchSize, this.hint, this.collation);
    }

    public String toString() {
        return "FindOptions{fields=" + this.fields + ", sort=" + this.sort + ", limit=" + this.limit + ", skip=" + this.skip + ", batchSize=" + this.batchSize + ", hint='" + this.hint + '\'' + ", collation=" + this.collation + '}';
    }
}

