/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Base64;
import java.util.Map;

public class AggregateOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, AggregateOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "allowDiskUse": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAllowDiskUse((Boolean)member.getValue());
                    break;
                }
                case "batchSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBatchSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "collation": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCollation(new CollationOptions((JsonObject)member.getValue()));
                    break;
                }
                case "maxTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxTime(((Number)member.getValue()).longValue());
                }
            }
        }
    }

    public static void toJson(AggregateOptions obj, JsonObject json) {
        AggregateOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(AggregateOptions obj, Map<String, Object> json) {
        if (obj.getAllowDiskUse() != null) {
            json.put("allowDiskUse", obj.getAllowDiskUse());
        }
        json.put("batchSize", obj.getBatchSize());
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation().toJson());
        }
        json.put("maxTime", obj.getMaxTime());
    }
}

