/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.core.Promise;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class SingleResultSubscriber<T>
implements Subscriber<T> {
    private T received;
    private final Promise<T> promise;

    public SingleResultSubscriber(Promise<T> promise) {
        Objects.requireNonNull(promise, "promise is null");
        this.promise = promise;
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        if (this.received == null) {
            this.received = t;
        }
    }

    public void onError(Throwable t) {
        this.promise.fail(t);
    }

    public void onComplete() {
        this.promise.complete(this.received);
    }
}

