/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.mongo.TimeSeriesGranularity;
import io.vertx.ext.mongo.TimeSeriesOptions;
import java.util.Base64;
import java.util.Map;

public class TimeSeriesOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, TimeSeriesOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "granularity": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setGranularity(TimeSeriesGranularity.valueOf((String)member.getValue()));
                    break;
                }
                case "metaField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMetaField((String)member.getValue());
                    break;
                }
                case "timeField": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setTimeField((String)member.getValue());
                }
            }
        }
    }

    static void toJson(TimeSeriesOptions obj, JsonObject json) {
        TimeSeriesOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(TimeSeriesOptions obj, Map<String, Object> json) {
        if (obj.getGranularity() != null) {
            json.put("granularity", obj.getGranularity().name());
        }
        if (obj.getMetaField() != null) {
            json.put("metaField", obj.getMetaField());
        }
        if (obj.getTimeField() != null) {
            json.put("timeField", obj.getTimeField());
        }
    }
}

