/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationStrength;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Base64;
import java.util.Map;

public class CollationOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    static void fromJson(Iterable<Map.Entry<String, Object>> json, CollationOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "backwards": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBackwards((Boolean)member.getValue());
                    break;
                }
                case "caseLevel": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCaseLevel((Boolean)member.getValue());
                    break;
                }
                case "locale": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocale((String)member.getValue());
                    break;
                }
                case "normalization": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNormalization((Boolean)member.getValue());
                    break;
                }
                case "numericOrdering": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNumericOrdering((Boolean)member.getValue());
                    break;
                }
                case "strength": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStrength(CollationStrength.valueOf((String)((String)member.getValue())));
                }
            }
        }
    }

    static void toJson(CollationOptions obj, JsonObject json) {
        CollationOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CollationOptions obj, Map<String, Object> json) {
        if (obj.isBackwards() != null) {
            json.put("backwards", obj.isBackwards());
        }
        if (obj.isCaseLevel() != null) {
            json.put("caseLevel", obj.isCaseLevel());
        }
        if (obj.getLocale() != null) {
            json.put("locale", obj.getLocale());
        }
        if (obj.isNormalization() != null) {
            json.put("normalization", obj.isNormalization());
        }
        if (obj.isNumericOrdering() != null) {
            json.put("numericOrdering", obj.isNumericOrdering());
        }
        if (obj.getStrength() != null) {
            json.put("strength", obj.getStrength().name());
        }
    }
}

