/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.WriteOption;
import java.util.Objects;

@DataObject
public class UpdateOptions {
    public static final boolean DEFAULT_UPSERT = false;
    public static final boolean DEFAULT_MULTI = false;
    public static final boolean DEFAULT_RETURN_NEW_DOCUMENT = false;
    private WriteOption writeOption;
    private boolean upsert;
    private boolean multi;
    private boolean returnNewDocument;
    private JsonArray arrayFilters;
    private JsonObject hint;
    private String hintString;
    private CollationOptions collation;

    public UpdateOptions() {
        this.upsert = false;
        this.multi = false;
        this.returnNewDocument = false;
    }

    public UpdateOptions(boolean upsert) {
        this.upsert = upsert;
        this.multi = false;
        this.returnNewDocument = false;
    }

    public UpdateOptions(boolean upsert, boolean multi) {
        this.upsert = upsert;
        this.multi = multi;
        this.returnNewDocument = false;
    }

    public UpdateOptions(UpdateOptions other) {
        this.writeOption = other.writeOption;
        this.upsert = other.upsert;
        this.multi = other.multi;
        this.returnNewDocument = other.returnNewDocument;
        this.arrayFilters = other.arrayFilters;
        this.hint = other.hint;
        this.hintString = other.hintString;
        this.collation = other.collation;
    }

    public UpdateOptions(JsonObject json) {
        String wo = json.getString("writeOption");
        if (wo != null) {
            this.writeOption = WriteOption.valueOf(wo.toUpperCase());
        }
        this.upsert = json.getBoolean("upsert", Boolean.valueOf(false));
        this.multi = json.getBoolean("multi", Boolean.valueOf(false));
        this.returnNewDocument = json.getBoolean("return_new_document", Boolean.valueOf(false));
        this.arrayFilters = json.getJsonArray("arrayFilters", null);
        this.hint = json.getJsonObject("hint", null);
        this.hintString = json.getString("hintString", null);
        if (json.getJsonObject("collation") != null) {
            this.collation = new CollationOptions(json.getJsonObject("collation"));
        }
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public UpdateOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public WriteOption getWriteOption() {
        return this.writeOption;
    }

    public UpdateOptions setWriteOption(WriteOption writeOption) {
        this.writeOption = writeOption;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public UpdateOptions setUpsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public boolean isReturningNewDocument() {
        return this.returnNewDocument;
    }

    public UpdateOptions setReturningNewDocument(boolean returnNewDocument) {
        this.returnNewDocument = returnNewDocument;
        return this;
    }

    public boolean isMulti() {
        return this.multi;
    }

    public UpdateOptions setMulti(boolean multi) {
        this.multi = multi;
        return this;
    }

    public JsonArray getArrayFilters() {
        return this.arrayFilters;
    }

    public UpdateOptions setArrayFilters(JsonArray arrayFilters) {
        this.arrayFilters = arrayFilters;
        return this;
    }

    public JsonObject getHint() {
        return this.hint;
    }

    public UpdateOptions setHint(JsonObject hint) {
        this.hint = hint;
        return this;
    }

    public String getHintString() {
        return this.hintString;
    }

    public UpdateOptions setHintString(String hintString) {
        this.hintString = hintString;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.writeOption != null) {
            json.put("writeOption", (Object)this.writeOption.name());
        }
        if (this.upsert) {
            json.put("upsert", (Object)true);
        }
        if (this.multi) {
            json.put("multi", (Object)true);
        }
        if (this.returnNewDocument) {
            json.put("return_new_document", (Object)true);
        }
        if (this.arrayFilters != null && !this.arrayFilters.isEmpty()) {
            json.put("arrayFilters", (Object)this.arrayFilters);
        }
        if (this.hint != null) {
            json.put("hint", (Object)this.hint);
        }
        if (this.hintString != null) {
            json.put("hintString", (Object)this.hintString);
        }
        if (this.collation != null) {
            json.put("collation", (Object)this.collation.toJson());
        }
        return json;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOptions that = (UpdateOptions)o;
        return this.upsert == that.upsert && this.multi == that.multi && this.returnNewDocument == that.returnNewDocument && this.writeOption == that.writeOption && Objects.equals(this.arrayFilters, that.arrayFilters) && Objects.equals(this.hint, that.hint) && Objects.equals(this.hintString, that.hintString) && Objects.equals(this.collation, that.collation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.writeOption, this.upsert, this.multi, this.returnNewDocument, this.arrayFilters, this.hint, this.hintString, this.collation});
    }

    public String toString() {
        return "UpdateOptions{writeOption=" + (Object)((Object)this.writeOption) + ", upsert=" + this.upsert + ", multi=" + this.multi + ", returnNewDocument=" + this.returnNewDocument + ", arrayFilters=" + this.arrayFilters + ", hint=" + this.hint + ", hintString='" + this.hintString + '\'' + ", collation=" + this.collation + '}';
    }
}

