/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.WriteOption;
import java.util.Objects;

@DataObject
public class BulkWriteOptions {
    public static final String ORDERED = "ordered";
    public static final String WRITE_OPTION = "writeOption";
    public static final boolean DEFAULT_ORDERED = true;
    private WriteOption writeOption;
    private boolean ordered;

    public BulkWriteOptions() {
        this.setOrdered(true);
    }

    public BulkWriteOptions(boolean ordered) {
        this.setOrdered(ordered);
    }

    public BulkWriteOptions(BulkWriteOptions other) {
        this.setWriteOption(other.getWriteOption());
        this.setOrdered(other.isOrdered());
    }

    public BulkWriteOptions(JsonObject json) {
        String wo = json.getString(WRITE_OPTION);
        if (wo != null) {
            this.setWriteOption(WriteOption.valueOf(wo.toUpperCase()));
        }
        this.setOrdered(json.getBoolean(ORDERED, Boolean.valueOf(true)));
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put(WRITE_OPTION, (Object)this.writeOption);
        json.put(ORDERED, (Object)this.ordered);
        return json;
    }

    public WriteOption getWriteOption() {
        return this.writeOption;
    }

    public BulkWriteOptions setWriteOption(WriteOption writeOption) {
        this.writeOption = writeOption;
        return this;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public BulkWriteOptions setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkWriteOptions that = (BulkWriteOptions)o;
        return this.ordered == that.ordered && this.writeOption == that.writeOption;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.writeOption, this.ordered});
    }

    public String toString() {
        return "BulkWriteOptions{writeOption=" + this.writeOption + ", ordered=" + this.ordered + "}";
    }
}

