/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

@DataObject
public class GridFsUploadOptions {
    private JsonObject metadata;
    private Integer chunkSizeBytes;

    public GridFsUploadOptions() {
    }

    public GridFsUploadOptions(GridFsUploadOptions options) {
        this.metadata = options.metadata;
        this.chunkSizeBytes = options.chunkSizeBytes;
    }

    public GridFsUploadOptions(JsonObject options) {
        this.metadata = options.getJsonObject("metadata");
        this.chunkSizeBytes = options.getInteger("chunkSizeBytes");
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.metadata != null) {
            json.put("metadata", (Object)this.metadata);
        }
        if (this.chunkSizeBytes != null) {
            json.put("chunkSizeBytes", (Object)this.chunkSizeBytes);
        }
        return json;
    }

    public JsonObject getMetadata() {
        return this.metadata;
    }

    public GridFsUploadOptions setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    public GridFsUploadOptions setChunkSizeBytes(Integer chunkSizeBytes) {
        this.chunkSizeBytes = chunkSizeBytes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridFsUploadOptions that = (GridFsUploadOptions)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.chunkSizeBytes, that.chunkSizeBytes);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.chunkSizeBytes);
    }

    public String toString() {
        return "GridFsUploadOptions{metadata=" + this.metadata + ", chunkSizeBytes=" + this.chunkSizeBytes + "}";
    }
}

