/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.SslSettings;
import io.vertx.core.Vertx;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

class SSLSettingsParser {
    private static final Logger log = LoggerFactory.getLogger(SSLSettingsParser.class);
    private final ConnectionString connectionString;
    private final JsonObject config;

    SSLSettingsParser(ConnectionString connectionString, JsonObject config) {
        this.connectionString = connectionString;
        this.config = config;
    }

    public SslSettings settings(Vertx vertx) {
        SslSettings.Builder builder = SslSettings.builder();
        this.fromConnectionString(builder);
        this.fromConfiguration(builder);
        SslSettings settings = builder.build();
        if (!settings.isEnabled()) {
            return settings;
        }
        PemKeyCertOptions pemKeyCertOptions = new PemKeyCertOptions();
        PemTrustOptions pemTrustOptions = new PemTrustOptions();
        if (this.config.containsKey("caPath")) {
            pemTrustOptions.addCertPath(this.config.getString("caPath"));
        }
        if (this.config.containsKey("keyPath") && this.config.containsKey("certPath")) {
            pemKeyCertOptions.addKeyPath(this.config.getString("keyPath"));
            pemKeyCertOptions.addCertPath(this.config.getString("certPath"));
        }
        try {
            TrustManager[] tms;
            if (this.config.getBoolean("trustAll", Boolean.valueOf(false)).booleanValue()) {
                log.warn((Object)"Mongo client has been set to trust ALL certificates, this can open you up to security issues. Make sure you know the risks.");
                tms = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
            } else {
                tms = !pemTrustOptions.getCertPaths().isEmpty() ? pemTrustOptions.getTrustManagerFactory(vertx).getTrustManagers() : null;
            }
            SSLContext context = SSLContext.getInstance("TLS");
            KeyManager[] mgr = pemKeyCertOptions.getKeyManagerFactory(vertx).getKeyManagers();
            context.init(mgr, tms, new SecureRandom());
            builder.context(context);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return builder.build();
    }

    private void fromConnectionString(SslSettings.Builder builder) {
        if (this.connectionString != null) {
            builder.applyConnectionString(this.connectionString);
        }
    }

    private void fromConfiguration(SslSettings.Builder builder) {
        if (this.config.containsKey("ssl")) {
            builder.enabled(this.config.getBoolean("ssl", Boolean.valueOf(false)).booleanValue());
        }
        if (this.config.containsKey("sslInvalidHostNameAllowed")) {
            builder.invalidHostNameAllowed(this.config.getBoolean("sslInvalidHostNameAllowed", Boolean.valueOf(false)).booleanValue());
        }
    }
}

