/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.MongoClientSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.AggregatePublisher;
import com.mongodb.reactivestreams.client.ChangeStreamPublisher;
import com.mongodb.reactivestreams.client.DistinctPublisher;
import com.mongodb.reactivestreams.client.FindPublisher;
import com.mongodb.reactivestreams.client.MongoClients;
import com.mongodb.reactivestreams.client.MongoCollection;
import com.mongodb.reactivestreams.client.MongoDatabase;
import com.mongodb.reactivestreams.client.gridfs.GridFSBucket;
import com.mongodb.reactivestreams.client.gridfs.GridFSBuckets;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.core.shareddata.Shareable;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.MongoGridFsClient;
import io.vertx.ext.mongo.RenameCollectionOptions;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.BufferingSubscriber;
import io.vertx.ext.mongo.impl.CompletionSubscriber;
import io.vertx.ext.mongo.impl.FailedStream;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.MappingAndBufferingSubscriber;
import io.vertx.ext.mongo.impl.MappingStream;
import io.vertx.ext.mongo.impl.MongoGridFsClientImpl;
import io.vertx.ext.mongo.impl.PublisherAdapter;
import io.vertx.ext.mongo.impl.SingleResultSubscriber;
import io.vertx.ext.mongo.impl.Utils;
import io.vertx.ext.mongo.impl.codec.json.JsonObjectCodec;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public class MongoClientImpl
implements MongoClient,
io.vertx.core.Closeable {
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final AggregateOptions DEFAULT_AGGREGATE_OPTIONS = new AggregateOptions();
    private static final BulkWriteOptions DEFAULT_BULK_WRITE_OPTIONS = new BulkWriteOptions();
    private static final String DS_LOCAL_MAP_NAME = "__vertx.MongoClient.datasources";
    public static final String COLLECTION_CANNOT_BE_NULL = "collection cannot be null";
    public static final String QUERY_CANNOT_BE_NULL = "query cannot be null";
    public static final String FIELD_NAME_CANNOT_BE_NULL = "fieldName cannot be null";
    public static final String UPDATE_CANNOT_BE_NULL = "update cannot be null";
    public static final String OPTIONS_CANNOT_BE_NULL = "options cannot be null";
    public static final String PIPELINE_CANNOT_BE_NULL = "pipeline cannot be null";
    public static final String FIND_OPTIONS_CANNOT_BE_NULL = "find options cannot be null";
    private final VertxInternal vertx;
    private final ContextInternal creatingContext;
    protected com.mongodb.reactivestreams.client.MongoClient mongo;
    private final MongoHolder holder;
    private final boolean useObjectId;

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        this.vertx = (VertxInternal)vertx;
        this.creatingContext = this.vertx.getOrCreateContext();
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo(vertx);
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
        this.creatingContext.addCloseHook((io.vertx.core.Closeable)this);
    }

    public MongoClientImpl(Vertx vertx, JsonObject config, String dataSourceName, MongoClientSettings settings) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(config);
        Objects.requireNonNull(dataSourceName);
        Objects.requireNonNull(settings);
        this.vertx = (VertxInternal)vertx;
        this.creatingContext = this.vertx.getOrCreateContext();
        this.holder = this.lookupHolder(dataSourceName, config);
        this.mongo = this.holder.mongo(vertx, settings);
        this.useObjectId = config.getBoolean("useObjectId", Boolean.valueOf(false));
        this.creatingContext.addCloseHook((io.vertx.core.Closeable)this);
    }

    @GenIgnore
    public static <T> DistinctPublisher<T> setDistinctOptions(DistinctPublisher<T> distinctPublisher, DistinctOptions distinctOptions) {
        if (distinctOptions != null && distinctOptions.getCollation() != null) {
            distinctPublisher.collation(distinctOptions.getCollation().toMongoDriverObject());
        }
        return distinctPublisher;
    }

    public void close(Promise<Void> completionHandler) {
        this.holder.close();
        completionHandler.complete();
    }

    @Override
    public Future<Void> close() {
        this.holder.close();
        this.creatingContext.removeCloseHook((io.vertx.core.Closeable)this);
        return this.vertx.getOrCreateContext().succeededFuture();
    }

    @Override
    public Future<@Nullable String> save(String collection, JsonObject document) {
        return this.saveWithOptions(collection, document, null);
    }

    @Override
    public Future<@Nullable String> saveWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(document, "document cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        Object id = document.getValue("_id");
        if (id == null) {
            PromiseInternal promise = this.vertx.promise();
            coll.insertOne((Object)document).subscribe(new CompletionSubscriber((Promise<Void>)promise));
            return promise.future().map(v -> this.useObjectId ? document.getJsonObject("_id").getString("$oid") : document.getString("_id"));
        }
        JsonObject filter = new JsonObject();
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        filter.put("_id", encodedDocument.getValue("_id"));
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(true);
        PromiseInternal promise = this.vertx.promise();
        coll.replaceOne((Bson)this.wrap(filter), (Object)encodedDocument, replaceOptions).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future().mapEmpty();
    }

    @Override
    public Future<@Nullable String> insert(String collection, JsonObject document) {
        return this.insertWithOptions(collection, document, null);
    }

    @Override
    public Future<@Nullable String> insertWithOptions(String collection, JsonObject document, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(document, "document cannot be null");
        JsonObject encodedDocument = this.encodeKeyWhenUseObjectId(document);
        boolean hasCustomId = document.containsKey("_id");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        PromiseInternal promise = this.vertx.promise();
        coll.insertOne((Object)encodedDocument).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future().map(v -> hasCustomId ? null : this.decodeKeyWhenUseObjectId(encodedDocument).getString("_id"));
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) {
        return this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) {
        return this.updateCollectionWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(update, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        JsonObjectBsonAdapter bupdate = this.wrap(this.encodeKeyWhenUseObjectId(this.generateIdIfNeeded(query, update, options)));
        com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
        JsonArray arrayFilters = options.getArrayFilters();
        if (arrayFilters != null && !arrayFilters.isEmpty()) {
            ArrayList<JsonObjectBsonAdapter> bArrayFilters = new ArrayList<JsonObjectBsonAdapter>(arrayFilters.size());
            for (int i = 0; i < arrayFilters.size(); ++i) {
                bArrayFilters.add(this.wrap(arrayFilters.getJsonObject(i)));
            }
            updateOptions.arrayFilters(bArrayFilters);
        }
        if (options.getHint() != null) {
            updateOptions.hint((Bson)this.wrap(options.getHint()));
        }
        if (options.getHintString() != null && !options.getHintString().isEmpty()) {
            updateOptions.hintString(options.getHintString());
        }
        if (options.getCollation() != null) {
            updateOptions.collation(options.getCollation().toMongoDriverObject());
        }
        Publisher publisher = options.isMulti() ? coll.updateMany((Bson)bquery, (Bson)bupdate, updateOptions) : coll.updateOne((Bson)bquery, (Bson)bupdate, updateOptions);
        PromiseInternal promise = this.vertx.promise();
        publisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray pipeline, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        ArrayList<JsonObjectBsonAdapter> bpipeline = new ArrayList<JsonObjectBsonAdapter>(pipeline.size());
        for (int i = 0; i < pipeline.size(); ++i) {
            bpipeline.add(this.wrap(pipeline.getJsonObject(i)));
        }
        com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
        JsonArray arrayFilters = options.getArrayFilters();
        if (arrayFilters != null && !arrayFilters.isEmpty()) {
            ArrayList<JsonObjectBsonAdapter> bArrayFilters = new ArrayList<JsonObjectBsonAdapter>(arrayFilters.size());
            for (int i = 0; i < arrayFilters.size(); ++i) {
                bArrayFilters.add(this.wrap(arrayFilters.getJsonObject(i)));
            }
            updateOptions.arrayFilters(bArrayFilters);
        }
        if (options.getHint() != null) {
            updateOptions.hint((Bson)this.wrap(options.getHint()));
        }
        if (options.getHintString() != null && !options.getHintString().isEmpty()) {
            updateOptions.hintString(options.getHintString());
        }
        if (options.getCollation() != null) {
            updateOptions.collation(options.getCollation().toMongoDriverObject());
        }
        Publisher publisher = coll.updateMany((Bson)bquery, bpipeline, updateOptions);
        PromiseInternal promise = this.vertx.promise();
        publisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    private JsonObject generateIdIfNeeded(JsonObject query, JsonObject update, UpdateOptions options) {
        if (options.isUpsert() && !update.containsKey("_id") && !this.useObjectId) {
            JsonObject setId = update.getJsonObject("$setOnInsert", new JsonObject());
            String id = query.containsKey("_id") ? query.getString("_id") : JsonObjectCodec.generateHexObjectId();
            setId.put("_id", (Object)id);
            update.put("$setOnInsert", (Object)setId);
        }
        return update;
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return this.replaceDocumentsWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public Future<@Nullable MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(replace, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        ReplaceOptions replaceOptions = new ReplaceOptions().upsert(options.isUpsert());
        if (options.getHint() != null) {
            replaceOptions.hint((Bson)this.wrap(options.getHint()));
        }
        if (options.getHintString() != null && !options.getHintString().isEmpty()) {
            replaceOptions.hintString(options.getHintString());
        }
        if (options.getCollation() != null) {
            replaceOptions.collation(options.getCollation().toMongoDriverObject());
        }
        PromiseInternal promise = this.vertx.promise();
        coll.replaceOne((Bson)bquery, (Object)this.encodeKeyWhenUseObjectId(replace), replaceOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientUpdateResult);
    }

    @Override
    public Future<List<JsonObject>> find(String collection, JsonObject query) {
        return this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public Future<List<JsonObject>> findWithOptions(String collection, JsonObject query, FindOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        PromiseInternal promise = this.vertx.promise();
        this.doFind(collection, this.deepEncodeKeyWhenUseObjectId(query), options).subscribe(new MappingAndBufferingSubscriber<JsonObject, JsonObject>(this::decodeKeyWhenUseObjectId, (Promise<List<JsonObject>>)promise));
        return promise.future();
    }

    @Override
    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        return this.findBatchWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        FindPublisher<JsonObject> view = this.doFind(collection, query, options);
        return new PublisherAdapter<JsonObject>((Context)this.vertx.getOrCreateContext(), (Publisher<JsonObject>)view, options.getBatchSize());
    }

    @Override
    public Future<@Nullable JsonObject> findOne(String collection, JsonObject query, @Nullable JsonObject fields) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.deepEncodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bfields = this.wrap(fields);
        PromiseInternal promise = this.vertx.promise();
        this.getCollection(collection).find((Bson)bquery).projection((Bson)bfields).first().subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(object -> object == null ? null : this.decodeKeyWhenUseObjectId((JsonObject)object));
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return this.findOneAndUpdateWithOptions(collection, query, update, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(update, UPDATE_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        JsonObject encodedQuery = this.deepEncodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        JsonObjectBsonAdapter bupdate = this.wrap(update);
        FindOneAndUpdateOptions foauOptions = new FindOneAndUpdateOptions();
        foauOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foauOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foauOptions.upsert(updateOptions.isUpsert());
        foauOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        JsonArray arrayFilters = updateOptions.getArrayFilters();
        if (arrayFilters != null && !arrayFilters.isEmpty()) {
            ArrayList<JsonObjectBsonAdapter> bArrayFilters = new ArrayList<JsonObjectBsonAdapter>(arrayFilters.size());
            for (int i = 0; i < arrayFilters.size(); ++i) {
                bArrayFilters.add(this.wrap(arrayFilters.getJsonObject(i)));
            }
            foauOptions.arrayFilters(bArrayFilters);
        }
        if (findOptions.getHint() != null) {
            foauOptions.hint((Bson)this.wrap(findOptions.getHint()));
        }
        if (findOptions.getHintString() != null && !findOptions.getHintString().isEmpty()) {
            foauOptions.hintString(findOptions.getHintString());
        }
        if (updateOptions.getHint() != null) {
            foauOptions.hint((Bson)this.wrap(updateOptions.getHint()));
        }
        if (updateOptions.getHintString() != null && !updateOptions.getHintString().isEmpty()) {
            foauOptions.hintString(updateOptions.getHintString());
        }
        if (findOptions.getCollation() != null) {
            foauOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        if (updateOptions.getCollation() != null) {
            foauOptions.collation(updateOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndUpdate((Bson)bquery, (Bson)bupdate, foauOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return this.findOneAndReplaceWithOptions(collection, query, replace, DEFAULT_FIND_OPTIONS, DEFAULT_UPDATE_OPTIONS);
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        Objects.requireNonNull(updateOptions, "update options cannot be null");
        JsonObject encodedQuery = this.deepEncodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndReplaceOptions foarOptions = new FindOneAndReplaceOptions();
        foarOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foarOptions.projection((Bson)this.wrap(findOptions.getFields()));
        foarOptions.upsert(updateOptions.isUpsert());
        foarOptions.returnDocument(updateOptions.isReturningNewDocument() ? ReturnDocument.AFTER : ReturnDocument.BEFORE);
        if (findOptions.getHint() != null) {
            foarOptions.hint((Bson)this.wrap(findOptions.getHint()));
        }
        if (findOptions.getHintString() != null && !findOptions.getHintString().isEmpty()) {
            foarOptions.hintString(findOptions.getHintString());
        }
        if (updateOptions.getHint() != null) {
            foarOptions.hint((Bson)this.wrap(updateOptions.getHint()));
        }
        if (updateOptions.getHintString() != null && !updateOptions.getHintString().isEmpty()) {
            foarOptions.hintString(updateOptions.getHintString());
        }
        if (findOptions.getCollation() != null) {
            foarOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndReplace((Bson)bquery, (Object)replace, foarOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndDelete(String collection, JsonObject query) {
        return this.findOneAndDeleteWithOptions(collection, query, DEFAULT_FIND_OPTIONS);
    }

    @Override
    public Future<@Nullable JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        Objects.requireNonNull(findOptions, FIND_OPTIONS_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.deepEncodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        FindOneAndDeleteOptions foadOptions = new FindOneAndDeleteOptions();
        foadOptions.sort((Bson)this.wrap(findOptions.getSort()));
        foadOptions.projection((Bson)this.wrap(findOptions.getFields()));
        if (findOptions.getHint() != null) {
            foadOptions.hint((Bson)this.wrap(findOptions.getHint()));
        }
        if (findOptions.getHintString() != null && !findOptions.getHintString().isEmpty()) {
            foadOptions.hintString(findOptions.getHintString());
        }
        if (findOptions.getCollation() != null) {
            foadOptions.collation(findOptions.getCollation().toMongoDriverObject());
        }
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.findOneAndDelete((Bson)bquery, foadOptions).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<Long> count(String collection, JsonObject query) {
        return this.countWithOptions(collection, query, null);
    }

    @Override
    public Future<Long> countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        Publisher countPublisher = countOptions != null ? coll.countDocuments((Bson)bquery, countOptions.toMongoDriverObject()) : coll.countDocuments((Bson)bquery);
        countPublisher.subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) {
        return this.removeDocumentsWithOptions(collection, query, null);
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        PromiseInternal promise = this.vertx.promise();
        coll.deleteMany((Bson)bquery).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientDeleteResult);
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocument(String collection, JsonObject query) {
        return this.removeDocumentWithOptions(collection, query, null);
    }

    @Override
    public Future<@Nullable MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, @Nullable WriteOption writeOption) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        PromiseInternal promise = this.vertx.promise();
        coll.deleteOne((Bson)bquery).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientDeleteResult);
    }

    @Override
    public Future<@Nullable MongoClientBulkWriteResult> bulkWrite(String collection, List<BulkOperation> operations) {
        return this.bulkWriteWithOptions(collection, operations, DEFAULT_BULK_WRITE_OPTIONS);
    }

    @Override
    public Future<@Nullable MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(operations, "operations cannot be null");
        Objects.requireNonNull(bulkWriteOptions, "bulkWriteOptions cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, bulkWriteOptions.getWriteOption());
        List<WriteModel<JsonObject>> bulkOperations = this.convertBulkOperations(operations);
        com.mongodb.client.model.BulkWriteOptions options = new com.mongodb.client.model.BulkWriteOptions().ordered(bulkWriteOptions.isOrdered());
        PromiseInternal promise = this.vertx.promise();
        coll.bulkWrite(bulkOperations, options).subscribe(new SingleResultSubscriber(promise));
        return promise.future().map(Utils::toMongoClientBulkWriteResult);
    }

    private List<WriteModel<JsonObject>> convertBulkOperations(List<BulkOperation> operations) {
        ArrayList<WriteModel<JsonObject>> result = new ArrayList<WriteModel<JsonObject>>(operations.size());
        block6: for (BulkOperation bulkOperation : operations) {
            switch (bulkOperation.getType()) {
                case DELETE: {
                    Bson bsonFilter = MongoClientImpl.toBson(this.deepEncodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    DeleteOptions deleteOptions = new DeleteOptions();
                    if (bulkOperation.getHint() != null) {
                        deleteOptions.hint(MongoClientImpl.toBson(bulkOperation.getHint()));
                    }
                    if (bulkOperation.getHintString() != null && !bulkOperation.getHintString().isEmpty()) {
                        deleteOptions.hintString(bulkOperation.getHintString());
                    }
                    if (bulkOperation.getCollation() != null) {
                        deleteOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new DeleteManyModel(bsonFilter, deleteOptions));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new DeleteOneModel(bsonFilter, deleteOptions));
                    continue block6;
                }
                case INSERT: {
                    result.add((WriteModel<JsonObject>)new InsertOneModel((Object)this.encodeKeyWhenUseObjectId(bulkOperation.getDocument())));
                    continue block6;
                }
                case REPLACE: {
                    ReplaceOptions replaceOptions = new ReplaceOptions();
                    if (bulkOperation.getCollation() != null) {
                        replaceOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    if (bulkOperation.getHint() != null) {
                        replaceOptions.hint(MongoClientImpl.toBson(bulkOperation.getHint()));
                    }
                    if (bulkOperation.getHintString() != null && !bulkOperation.getHintString().isEmpty()) {
                        replaceOptions.hintString(bulkOperation.getHintString());
                    }
                    result.add((WriteModel<JsonObject>)new ReplaceOneModel(MongoClientImpl.toBson(this.deepEncodeKeyWhenUseObjectId(bulkOperation.getFilter())), (Object)bulkOperation.getDocument(), replaceOptions.upsert(bulkOperation.isUpsert())));
                    continue block6;
                }
                case UPDATE: {
                    Bson filter = MongoClientImpl.toBson(this.deepEncodeKeyWhenUseObjectId(bulkOperation.getFilter()));
                    Bson document = MongoClientImpl.toBson(this.encodeKeyWhenUseObjectId(bulkOperation.getDocument()));
                    com.mongodb.client.model.UpdateOptions updateOptions = new com.mongodb.client.model.UpdateOptions().upsert(bulkOperation.isUpsert());
                    if (bulkOperation.getCollation() != null) {
                        updateOptions.collation(bulkOperation.getCollation().toMongoDriverObject());
                    }
                    if (bulkOperation.getHint() != null) {
                        updateOptions.hint(MongoClientImpl.toBson(bulkOperation.getHint()));
                    }
                    if (bulkOperation.getHintString() != null && !bulkOperation.getHintString().isEmpty()) {
                        updateOptions.hintString(bulkOperation.getHintString());
                    }
                    if (bulkOperation.isMulti()) {
                        result.add((WriteModel<JsonObject>)new UpdateManyModel(filter, document, updateOptions));
                        continue block6;
                    }
                    result.add((WriteModel<JsonObject>)new UpdateOneModel(filter, document, updateOptions));
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown bulk operation type: " + bulkOperation.getClass());
        }
        return result;
    }

    @Override
    public Future<Void> createCollection(String collectionName) {
        Objects.requireNonNull(collectionName, "collectionName cannot be null");
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.createCollection(collectionName).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        Objects.requireNonNull(collectionName, "collectionName cannot be null");
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.createCollection(collectionName, collectionOptions.toMongoDriverObject()).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<List<String>> getCollections() {
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.listCollectionNames().subscribe(new BufferingSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<Void> dropCollection(String collection) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.drop().subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> renameCollection(String oldCollectionName, String newCollectionName) {
        return this.renameCollectionWithOptions(oldCollectionName, newCollectionName, new RenameCollectionOptions());
    }

    @Override
    public Future<Void> renameCollectionWithOptions(String oldCollectionName, String newCollectionName, RenameCollectionOptions options) {
        Objects.requireNonNull(oldCollectionName, "oldCollectionName can not be null");
        Objects.requireNonNull(newCollectionName, "newCollectionName can not be null");
        Objects.requireNonNull(options, OPTIONS_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(oldCollectionName);
        PromiseInternal promise = this.vertx.promise();
        MongoNamespace newNamespace = new MongoNamespace(coll.getNamespace().getDatabaseName(), newCollectionName);
        coll.renameCollection(newNamespace, options.toMongoDriverObject()).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> createIndex(String collection, JsonObject key) {
        return this.createIndexWithOptions(collection, key, new IndexOptions());
    }

    @Override
    public Future<Void> createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(key, FIELD_NAME_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        com.mongodb.client.model.IndexOptions driverOpts = this.mongoIndexOptions(options);
        PromiseInternal promise = this.vertx.promise();
        coll.createIndex((Bson)this.wrap(key), driverOpts).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> createIndexes(String collection, List<IndexModel> indexes) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        List transformIndexes = indexes.stream().map(it -> {
            if (it.getOptions() != null) {
                return new com.mongodb.client.model.IndexModel((Bson)this.wrap(it.getKey()), this.mongoIndexOptions(it.getOptions()));
            }
            return new com.mongodb.client.model.IndexModel((Bson)this.wrap(it.getKey()));
        }).collect(Collectors.toList());
        PromiseInternal promise = this.vertx.promise();
        this.getCollection(collection).createIndexes(transformIndexes).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    private static Bson toBson(@Nullable JsonObject json) {
        return json == null ? null : BsonDocument.parse((String)json.encode());
    }

    @Override
    public Future<JsonArray> listIndexes(String collection) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.listIndexes(JsonObject.class).subscribe(new BufferingSubscriber(promise));
        return promise.future().map(JsonArray::new);
    }

    @Override
    public Future<Void> dropIndex(String collection, String indexName) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(indexName, "indexName cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.dropIndex(indexName).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<Void> dropIndex(String collection, JsonObject key) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(key, FIELD_NAME_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        PromiseInternal promise = this.vertx.promise();
        coll.dropIndex((Bson)this.wrap(key)).subscribe(new CompletionSubscriber((Promise<Void>)promise));
        return promise.future();
    }

    @Override
    public Future<@Nullable JsonObject> runCommand(String commandName, JsonObject command) {
        Objects.requireNonNull(commandName, "commandName cannot be null");
        Objects.requireNonNull(command, "command cannot be null");
        JsonObject json = new JsonObject();
        Object commandVal = command.getValue(commandName);
        if (commandVal == null) {
            throw new IllegalArgumentException("commandBody does not contain key for " + commandName);
        }
        json.put(commandName, commandVal);
        command.forEach(entry -> {
            if (!((String)entry.getKey()).equals(commandName)) {
                json.put((String)entry.getKey(), entry.getValue());
            }
        });
        PromiseInternal promise = this.vertx.promise();
        this.holder.db.runCommand((Bson)this.wrap(json), JsonObject.class).subscribe(new SingleResultSubscriber(promise));
        return promise.future();
    }

    @Override
    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname) {
        return this.distinct(collection, fieldName, resultClassname, null);
    }

    @Override
    public Future<JsonArray> distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, new JsonObject(), distinctOptions);
    }

    @Override
    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctWithQuery(collection, fieldName, resultClassname, query, null);
    }

    @Override
    public Future<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        try {
            PromiseInternal promise = this.vertx.promise();
            this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query, distinctOptions).subscribe(new BufferingSubscriber(promise));
            return promise.future().map(JsonArray::new);
        }
        catch (ClassNotFoundException e) {
            return this.vertx.getOrCreateContext().failedFuture((Throwable)e);
        }
    }

    @Override
    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        return this.distinctBatch(collection, fieldName, resultClassname, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, new JsonObject(), distinctOptions);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, 20, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        return this.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, null);
    }

    @Override
    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        try {
            DistinctPublisher<?> distinctValuesWithQuery = this.findDistinctValuesWithQuery(collection, fieldName, resultClassname, query, distinctOptions);
            PublisherAdapter readStream = new PublisherAdapter((Context)this.vertx.getOrCreateContext(), (Publisher<?>)distinctValuesWithQuery, batchSize);
            return new MappingStream<Object, JsonObject>(readStream, value -> new JsonObject().put(fieldName, value));
        }
        catch (ClassNotFoundException e) {
            return new FailedStream(e);
        }
    }

    @Override
    public Future<MongoGridFsClient> createDefaultGridFsBucketService() {
        return this.createGridFsBucketService("fs");
    }

    @Override
    public Future<MongoGridFsClient> createGridFsBucketService(String bucketName) {
        MongoGridFsClientImpl impl = new MongoGridFsClientImpl(this.vertx, this, this.getGridFSBucket(bucketName), this.holder.db.getCodecRegistry());
        return Future.succeededFuture((Object)impl);
    }

    private GridFSBucket getGridFSBucket(String bucketName) {
        return GridFSBuckets.create((MongoDatabase)this.holder.db, (String)bucketName);
    }

    @Override
    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        return this.aggregateWithOptions(collection, pipeline, DEFAULT_AGGREGATE_OPTIONS);
    }

    @Override
    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        AggregatePublisher<JsonObject> view = this.doAggregate(collection, pipeline, options);
        return new PublisherAdapter<JsonObject>((Context)this.vertx.getOrCreateContext(), (Publisher<JsonObject>)view, options.getBatchSize());
    }

    @Override
    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ArrayList<JsonObjectBsonAdapter> bpipeline = new ArrayList<JsonObjectBsonAdapter>(pipeline.size());
        for (int i = 0; i < pipeline.size(); ++i) {
            bpipeline.add(this.wrap(pipeline.getJsonObject(i)));
        }
        ChangeStreamPublisher changeStreamPublisher = coll.watch(bpipeline, JsonObject.class);
        if (withUpdatedDoc) {
            changeStreamPublisher.fullDocument(FullDocument.UPDATE_LOOKUP);
        }
        if (batchSize < 1) {
            batchSize = 1;
        }
        return new PublisherAdapter<ChangeStreamDocument<JsonObject>>((Context)this.vertx.getOrCreateContext(), (Publisher<ChangeStreamDocument<JsonObject>>)changeStreamPublisher, batchSize);
    }

    private DistinctPublisher<?> findDistinctValuesWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) throws ClassNotFoundException {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(fieldName, FIELD_NAME_CANNOT_BE_NULL);
        Objects.requireNonNull(query, QUERY_CANNOT_BE_NULL);
        JsonObject encodedQuery = this.deepEncodeKeyWhenUseObjectId(query);
        JsonObjectBsonAdapter bquery = this.wrap(encodedQuery);
        MongoCollection<JsonObject> mongoCollection = this.getCollection(collection);
        Class<?> resultClass = this.getClass().getClassLoader().loadClass(resultClassname);
        return MongoClientImpl.setDistinctOptions(mongoCollection.distinct(fieldName, (Bson)bquery, resultClass), distinctOptions);
    }

    private AggregatePublisher<JsonObject> doAggregate(String collection, JsonArray pipeline, AggregateOptions aggregateOptions) {
        Objects.requireNonNull(collection, COLLECTION_CANNOT_BE_NULL);
        Objects.requireNonNull(pipeline, PIPELINE_CANNOT_BE_NULL);
        Objects.requireNonNull(aggregateOptions, "aggregateOptions cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        ArrayList<JsonObjectBsonAdapter> bpipeline = new ArrayList<JsonObjectBsonAdapter>(pipeline.size());
        for (int i = 0; i < pipeline.size(); ++i) {
            bpipeline.add(this.wrap(pipeline.getJsonObject(i)));
        }
        AggregatePublisher aggregate = coll.aggregate(bpipeline, JsonObject.class);
        if (aggregateOptions.getCollation() != null) {
            aggregate.collation(aggregateOptions.getCollation().toMongoDriverObject());
        }
        if (aggregateOptions.getBatchSize() != -1) {
            aggregate.batchSize(aggregateOptions.getBatchSize());
        }
        if (aggregateOptions.getMaxTime() > 0L) {
            aggregate.maxTime(aggregateOptions.getMaxTime(), TimeUnit.MILLISECONDS);
        }
        if (aggregateOptions.getAllowDiskUse() != null) {
            aggregate.allowDiskUse(aggregateOptions.getAllowDiskUse());
        }
        return aggregate;
    }

    JsonArray deepEncodeKeyWhenUseObjectId(JsonArray arr) {
        if (!this.useObjectId) {
            return arr;
        }
        JsonArray newArr = new JsonArray(new ArrayList(arr.size()));
        for (Object item : arr) {
            if (item instanceof JsonArray) {
                newArr.add((Object)this.deepEncodeKeyWhenUseObjectId((JsonArray)item));
                continue;
            }
            if (item instanceof List) {
                newArr.add((Object)this.deepEncodeKeyWhenUseObjectId(new JsonArray((List)item)));
                continue;
            }
            if (item instanceof JsonObject) {
                newArr.add((Object)this.deepEncodeKeyWhenUseObjectId((JsonObject)item));
                continue;
            }
            if (item instanceof Map) {
                newArr.add((Object)this.deepEncodeKeyWhenUseObjectId(new JsonObject((Map)item)));
                continue;
            }
            newArr.add(item);
        }
        return newArr;
    }

    JsonObject deepEncodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        JsonObject newJson = new JsonObject(new LinkedHashMap(json.size()));
        for (Map.Entry entry : json) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.equals("_id") && value instanceof String && ObjectId.isValid((String)((String)value))) {
                newJson.put(key, (Object)new JsonObject().put("$oid", value));
                continue;
            }
            if (value instanceof JsonObject) {
                newJson.put(key, (Object)this.deepEncodeKeyWhenUseObjectId((JsonObject)value));
                continue;
            }
            if (value instanceof Map) {
                newJson.put(key, (Object)this.deepEncodeKeyWhenUseObjectId(new JsonObject((Map)value)));
                continue;
            }
            if (value instanceof JsonArray) {
                newJson.put(key, (Object)this.deepEncodeKeyWhenUseObjectId((JsonArray)value));
                continue;
            }
            if (value instanceof List) {
                newJson.put(key, (Object)this.deepEncodeKeyWhenUseObjectId(new JsonArray((List)value)));
                continue;
            }
            newJson.put(key, value);
        }
        return newJson;
    }

    JsonObject encodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idString = json.getValue("_id", null);
        if (idString instanceof String && ObjectId.isValid((String)((String)idString))) {
            json.put("_id", (Object)new JsonObject().put("$oid", idString));
        }
        return json;
    }

    private JsonObject decodeKeyWhenUseObjectId(JsonObject json) {
        if (!this.useObjectId) {
            return json;
        }
        Object idField = json.getValue("_id", null);
        if (!(idField instanceof JsonObject)) {
            return json;
        }
        Object idString = ((JsonObject)idField).getValue("$oid", null);
        if (!(idString instanceof String)) {
            return json;
        }
        json.put("_id", idString);
        return json;
    }

    private FindPublisher<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        JsonObjectBsonAdapter bquery = this.wrap(this.deepEncodeKeyWhenUseObjectId(query));
        FindPublisher find = coll.find((Bson)bquery, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Bson)this.wrap(options.getSort()));
        }
        if (options.getFields() != null) {
            find.projection((Bson)this.wrap(options.getFields()));
        }
        if (options.getHint() != null) {
            find.hint((Bson)this.wrap(options.getHint()));
        }
        if (options.getHintString() != null && !options.getHintString().isEmpty()) {
            find.hintString(options.getHintString());
        }
        if (options.getCollation() != null) {
            find.collation(options.getCollation().toMongoDriverObject());
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, @Nullable WriteOption writeOption) {
        MongoCollection coll = this.holder.db.getCollection(name, JsonObject.class);
        if (coll != null && writeOption != null) {
            coll = coll.withWriteConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return coll;
    }

    private com.mongodb.client.model.IndexOptions mongoIndexOptions(IndexOptions options) {
        CollationOptions co = options.getCollation();
        com.mongodb.client.model.IndexOptions o = new com.mongodb.client.model.IndexOptions().background(options.isBackground()).unique(options.isUnique()).name(options.getName()).sparse(options.isSparse()).expireAfter(options.getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(options.getVersion()).weights(MongoClientImpl.toBson(options.getWeights())).defaultLanguage(options.getDefaultLanguage()).languageOverride(options.getLanguageOverride()).textVersion(options.getTextVersion()).sphereVersion(options.getSphereVersion()).bits(options.getBits()).min(options.getMin()).max(options.getMax()).storageEngine(MongoClientImpl.toBson(options.getStorageEngine())).partialFilterExpression(MongoClientImpl.toBson(options.getPartialFilterExpression()));
        if (co != null) {
            o.collation(co.toMongoDriverObject());
        }
        return o;
    }

    @Nullable JsonObjectBsonAdapter wrap(@Nullable JsonObject jsonObject) {
        return jsonObject == null ? null : new JsonObjectBsonAdapter(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromMap(LocalMap<String, MongoHolder> map, String dataSourceName) {
        VertxInternal vertxInternal = this.vertx;
        synchronized (vertxInternal) {
            map.remove((Object)dataSourceName);
            if (map.isEmpty()) {
                map.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MongoHolder lookupHolder(String datasourceName, JsonObject config) {
        VertxInternal vertxInternal = this.vertx;
        synchronized (vertxInternal) {
            LocalMap map = this.vertx.sharedData().getLocalMap(DS_LOCAL_MAP_NAME);
            MongoHolder theHolder = (MongoHolder)map.get((Object)datasourceName);
            if (theHolder == null) {
                theHolder = new MongoHolder(config, () -> this.removeFromMap((LocalMap<String, MongoHolder>)map, datasourceName));
                map.put((Object)datasourceName, (Object)theHolder);
            } else {
                theHolder.incRefCount();
            }
            return theHolder;
        }
    }

    private class MongoHolder
    implements Shareable {
        com.mongodb.reactivestreams.client.MongoClient mongo;
        MongoDatabase db;
        JsonObject config;
        Runnable closeRunner;
        int refCount = 1;

        MongoHolder(JsonObject config, Runnable closeRunner) {
            this.config = config;
            this.closeRunner = closeRunner;
        }

        synchronized com.mongodb.reactivestreams.client.MongoClient mongo(Vertx vertx) {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(vertx, this.config);
                this.mongo = MongoClients.create((MongoClientSettings)parser.settings());
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized com.mongodb.reactivestreams.client.MongoClient mongo(Vertx vertx, MongoClientSettings settings) {
            if (this.mongo == null) {
                MongoClientOptionsParser parser = new MongoClientOptionsParser(vertx, this.config);
                this.mongo = MongoClients.create((MongoClientSettings)settings);
                this.db = this.mongo.getDatabase(parser.database());
            }
            return this.mongo;
        }

        synchronized void incRefCount() {
            ++this.refCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Runnable callback;
            com.mongodb.reactivestreams.client.MongoClient client;
            MongoHolder mongoHolder = this;
            synchronized (mongoHolder) {
                if (--this.refCount > 0) {
                    return;
                }
                client = this.mongo;
                this.mongo = null;
                callback = this.closeRunner;
                this.closeRunner = null;
            }
            if (callback != null) {
                callback.run();
            }
            if (client != null) {
                MongoClientImpl.this.vertx.executeBlocking(() -> MongoHolder.lambda$close$0((Closeable)client));
            }
        }

        private static /* synthetic */ Object lambda$close$0(Closeable client) throws Exception {
            client.close();
            return null;
        }
    }
}

