/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Map;

public class AggregateOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, AggregateOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "collation": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCollation(new CollationOptions((JsonObject)member.getValue()));
                    break;
                }
                case "maxTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "batchSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setBatchSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "allowDiskUse": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setAllowDiskUse((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(AggregateOptions obj, JsonObject json) {
        AggregateOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(AggregateOptions obj, Map<String, Object> json) {
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation().toJson());
        }
        json.put("maxTime", obj.getMaxTime());
        json.put("batchSize", obj.getBatchSize());
        if (obj.getAllowDiskUse() != null) {
            json.put("allowDiskUse", obj.getAllowDiskUse());
        }
    }
}

