/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import com.mongodb.client.model.CollationStrength;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Map;

public class CollationOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, CollationOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "normalization": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNormalization((Boolean)member.getValue());
                    break;
                }
                case "locale": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setLocale((String)member.getValue());
                    break;
                }
                case "caseLevel": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCaseLevel((Boolean)member.getValue());
                    break;
                }
                case "strength": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setStrength(CollationStrength.valueOf((String)((String)member.getValue())));
                    break;
                }
                case "numericOrdering": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setNumericOrdering((Boolean)member.getValue());
                    break;
                }
                case "backwards": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setBackwards((Boolean)member.getValue());
                }
            }
        }
    }

    static void toJson(CollationOptions obj, JsonObject json) {
        CollationOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CollationOptions obj, Map<String, Object> json) {
        if (obj.isNormalization() != null) {
            json.put("normalization", obj.isNormalization());
        }
        if (obj.getLocale() != null) {
            json.put("locale", obj.getLocale());
        }
        if (obj.isCaseLevel() != null) {
            json.put("caseLevel", obj.isCaseLevel());
        }
        if (obj.getStrength() != null) {
            json.put("strength", obj.getStrength().name());
        }
        if (obj.isNumericOrdering() != null) {
            json.put("numericOrdering", obj.isNumericOrdering());
        }
        if (obj.isBackwards() != null) {
            json.put("backwards", obj.isBackwards());
        }
    }
}

