/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import io.vertx.ext.mongo.CountOptions;
import java.util.Map;

public class CountOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, CountOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "hint": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setHint(((JsonObject)member.getValue()).copy());
                    break;
                }
                case "hintString": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHintString((String)member.getValue());
                    break;
                }
                case "limit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "skip": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSkip(((Number)member.getValue()).intValue());
                    break;
                }
                case "maxTime": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setMaxTime(((Number)member.getValue()).longValue());
                    break;
                }
                case "collation": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    obj.setCollation(new CollationOptions((JsonObject)member.getValue()));
                }
            }
        }
    }

    static void toJson(CountOptions obj, JsonObject json) {
        CountOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(CountOptions obj, Map<String, Object> json) {
        if (obj.getHint() != null) {
            json.put("hint", obj.getHint());
        }
        if (obj.getHintString() != null) {
            json.put("hintString", obj.getHintString());
        }
        if (obj.getLimit() != null) {
            json.put("limit", obj.getLimit());
        }
        if (obj.getSkip() != null) {
            json.put("skip", obj.getSkip());
        }
        if (obj.getMaxTime() != null) {
            json.put("maxTime", obj.getMaxTime());
        }
        if (obj.getCollation() != null) {
            json.put("collation", obj.getCollation().toJson());
        }
    }
}

