/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.CollationOptions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@DataObject
public class IndexOptions {
    public static final boolean DEFAULT_BACKGROUND = false;
    public static final boolean DEFAULT_UNIQUE = false;
    public static final boolean DEFAULT_SPARSE = false;
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Long expireAfterSeconds;
    private Integer version;
    private JsonObject weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textVersion;
    private Integer sphereVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private JsonObject storageEngine;
    private JsonObject partialFilterExpression;
    private CollationOptions collation;

    public IndexOptions() {
        this.background = false;
        this.unique = false;
        this.sparse = false;
    }

    public IndexOptions(IndexOptions options) {
        this.background = options.background;
        this.unique = options.unique;
        this.name = options.name;
        this.sparse = options.sparse;
        this.expireAfterSeconds = options.expireAfterSeconds;
        this.version = options.version;
        this.weights = options.weights;
        this.defaultLanguage = options.defaultLanguage;
        this.languageOverride = options.languageOverride;
        this.textVersion = options.textVersion;
        this.sphereVersion = options.sphereVersion;
        this.bits = options.bits;
        this.min = options.min;
        this.max = options.max;
        this.storageEngine = options.storageEngine;
        this.partialFilterExpression = options.partialFilterExpression;
        this.collation = options.collation;
    }

    public IndexOptions(JsonObject options) {
        this.background = options.getBoolean("background", Boolean.valueOf(false));
        this.unique = options.getBoolean("unique", Boolean.valueOf(false));
        this.name = options.getString("name");
        this.sparse = options.getBoolean("sparse", Boolean.valueOf(false));
        this.expireAfterSeconds = options.getLong("expireAfterSeconds");
        this.version = options.getInteger("version");
        this.weights = options.getJsonObject("weights");
        this.defaultLanguage = options.getString("defaultLanguage");
        this.languageOverride = options.getString("languageOverride");
        this.textVersion = options.getInteger("textVersion");
        this.sphereVersion = options.getInteger("sphereVersion");
        this.bits = options.getInteger("bits");
        this.min = options.getDouble("min");
        this.max = options.getDouble("max");
        this.storageEngine = options.getJsonObject("storageEngine");
        this.partialFilterExpression = options.getJsonObject("partialFilterExpression");
        this.collation = options.getJsonObject("collation") != null ? new CollationOptions(options.getJsonObject("collation")) : null;
    }

    public CollationOptions getCollation() {
        return this.collation;
    }

    public IndexOptions setCollation(CollationOptions collation) {
        this.collation = collation;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("background", (Object)this.background);
        json.put("unique", (Object)this.unique);
        json.put("sparse", (Object)this.sparse);
        if (this.name != null) {
            json.put("name", (Object)this.name);
        }
        if (this.expireAfterSeconds != null) {
            json.put("expireAfterSeconds", (Object)this.expireAfterSeconds);
        }
        if (this.version != null) {
            json.put("version", (Object)this.version);
        }
        if (this.weights != null) {
            json.put("weights", (Object)this.weights);
        }
        if (this.defaultLanguage != null) {
            json.put("defaultLanguage", (Object)this.defaultLanguage);
        }
        if (this.languageOverride != null) {
            json.put("languageOverride", (Object)this.languageOverride);
        }
        if (this.textVersion != null) {
            json.put("textVersion", (Object)this.textVersion);
        }
        if (this.sphereVersion != null) {
            json.put("sphereVersion", (Object)this.sphereVersion);
        }
        if (this.bits != null) {
            json.put("bits", (Object)this.bits);
        }
        if (this.min != null) {
            json.put("min", (Object)this.min);
        }
        if (this.max != null) {
            json.put("max", (Object)this.max);
        }
        if (this.storageEngine != null) {
            json.put("storageEngine", (Object)this.storageEngine);
        }
        if (this.partialFilterExpression != null) {
            json.put("partialFilterExpression", (Object)this.partialFilterExpression);
        }
        if (this.collation != null) {
            json.put("collation", (Object)this.collation.toJson());
        }
        return json;
    }

    public boolean isBackground() {
        return this.background;
    }

    public IndexOptions background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public IndexOptions unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public IndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public IndexOptions sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Long getExpireAfter(TimeUnit timeUnit) {
        if (this.expireAfterSeconds == null) {
            return null;
        }
        return timeUnit.convert(this.expireAfterSeconds, TimeUnit.SECONDS);
    }

    public IndexOptions expireAfter(Long expireAfter, TimeUnit timeUnit) {
        this.expireAfterSeconds = expireAfter == null ? null : Long.valueOf(TimeUnit.SECONDS.convert(expireAfter, timeUnit));
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public IndexOptions version(Integer version) {
        this.version = version;
        return this;
    }

    public JsonObject getWeights() {
        return this.weights;
    }

    public IndexOptions weights(JsonObject weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public IndexOptions defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public IndexOptions languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextVersion() {
        return this.textVersion;
    }

    public IndexOptions textVersion(Integer textVersion) {
        this.textVersion = textVersion;
        return this;
    }

    public Integer getSphereVersion() {
        return this.sphereVersion;
    }

    public IndexOptions sphereVersion(Integer sphereVersion) {
        this.sphereVersion = sphereVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public IndexOptions bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public IndexOptions min(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public IndexOptions max(Double max) {
        this.max = max;
        return this;
    }

    public JsonObject getStorageEngine() {
        return this.storageEngine;
    }

    public IndexOptions storageEngine(JsonObject storageEngine) {
        this.storageEngine = storageEngine;
        return this;
    }

    public JsonObject getPartialFilterExpression() {
        return this.partialFilterExpression;
    }

    public IndexOptions partialFilterExpression(JsonObject partialFilterExpression) {
        this.partialFilterExpression = partialFilterExpression;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexOptions that = (IndexOptions)o;
        return this.background == that.background && this.unique == that.unique && this.sparse == that.sparse && Objects.equals(this.name, that.name) && Objects.equals(this.expireAfterSeconds, that.expireAfterSeconds) && Objects.equals(this.version, that.version) && Objects.equals(this.weights, that.weights) && Objects.equals(this.defaultLanguage, that.defaultLanguage) && Objects.equals(this.languageOverride, that.languageOverride) && Objects.equals(this.textVersion, that.textVersion) && Objects.equals(this.sphereVersion, that.sphereVersion) && Objects.equals(this.bits, that.bits) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && Objects.equals(this.storageEngine, that.storageEngine) && Objects.equals(this.partialFilterExpression, that.partialFilterExpression) && Objects.equals(this.collation, that.collation);
    }

    public int hashCode() {
        return Objects.hash(this.background, this.unique, this.name, this.sparse, this.expireAfterSeconds, this.version, this.weights, this.defaultLanguage, this.languageOverride, this.textVersion, this.sphereVersion, this.bits, this.min, this.max, this.storageEngine, this.partialFilterExpression, this.collation);
    }

    public String toString() {
        return "IndexOptions{background=" + this.background + ", unique=" + this.unique + ", name='" + this.name + "', sparse=" + this.sparse + ", expireAfterSeconds=" + this.expireAfterSeconds + ", version=" + this.version + ", weights=" + String.valueOf(this.weights) + ", defaultLanguage='" + this.defaultLanguage + "', languageOverride='" + this.languageOverride + "', textVersion=" + this.textVersion + ", sphereVersion=" + this.sphereVersion + ", bits=" + this.bits + ", min=" + this.min + ", max=" + this.max + ", storageEngine=" + String.valueOf(this.storageEngine) + ", partialFilterExpression=" + String.valueOf(this.partialFilterExpression) + ", collation=" + String.valueOf(this.collation) + "}";
    }
}

