/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.connection.ConnectionPoolSettings;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

public class ConnectionPoolSettingsParser {
    private final ConnectionPoolSettings settings;

    public ConnectionPoolSettingsParser(ConnectionString connectionString, JsonObject config) {
        Long maintenanceFrequencyMS;
        Long maintenanceInitialDelayMS;
        Long waitQueueTimeoutMS;
        Long maxLifeTimeMS;
        Long maxIdleTimeMS;
        Integer minPoolSize;
        Integer maxPoolSize;
        ConnectionPoolSettings.Builder settings = ConnectionPoolSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        }
        if ((maxPoolSize = config.getInteger("maxPoolSize")) != null) {
            settings.maxSize(maxPoolSize.intValue());
        }
        if ((minPoolSize = config.getInteger("minPoolSize")) != null) {
            settings.minSize(minPoolSize.intValue());
        }
        if ((maxIdleTimeMS = config.getLong("maxIdleTimeMS")) != null) {
            settings.maxConnectionIdleTime(maxIdleTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maxLifeTimeMS = config.getLong("maxLifeTimeMS")) != null) {
            settings.maxConnectionLifeTime(maxLifeTimeMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((waitQueueTimeoutMS = config.getLong("waitQueueTimeoutMS")) != null) {
            settings.maxWaitTime(waitQueueTimeoutMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maintenanceInitialDelayMS = config.getLong("maintenanceInitialDelayMS")) != null) {
            settings.maintenanceInitialDelay(maintenanceInitialDelayMS.longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maintenanceFrequencyMS = config.getLong("maintenanceFrequencyMS")) != null) {
            settings.maintenanceFrequency(maintenanceFrequencyMS.longValue(), TimeUnit.MILLISECONDS);
        }
        this.settings = settings.build();
    }

    public ConnectionPoolSettings settings() {
        return this.settings;
    }
}

