/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReadPreferenceParser {
    private final ReadPreference readPreference;

    public ReadPreferenceParser(ConnectionString connectionString, JsonObject config) {
        ReadPreference readPreference = this.fromConfig(config);
        if (readPreference == null && connectionString != null) {
            readPreference = connectionString.getReadPreference();
        }
        this.readPreference = readPreference;
    }

    private ReadPreference fromConfig(JsonObject config) {
        ReadPreference readPreference = null;
        String rps = config.getString("readPreference");
        if (rps != null) {
            JsonArray readPreferenceTags = config.getJsonArray("readPreferenceTags");
            if (readPreferenceTags == null) {
                readPreference = ReadPreference.valueOf((String)rps);
                if (readPreference == null) {
                    throw new IllegalArgumentException("Invalid ReadPreference " + rps);
                }
            } else {
                ArrayList tagSet = new ArrayList();
                readPreferenceTags.forEach(o -> {
                    String tagString = (String)o;
                    List tags = Stream.of(tagString.trim().split(",")).map(s -> s.split(":")).filter(array -> {
                        if (((String[])array).length != 2) {
                            throw new IllegalArgumentException("Invalid readPreferenceTags value '" + tagString + "'");
                        }
                        return true;
                    }).map(array -> new Tag(array[0], array[1])).collect(Collectors.toList());
                    tagSet.add(new TagSet(tags));
                });
                readPreference = ReadPreference.valueOf((String)rps, tagSet);
            }
        }
        return readPreference;
    }

    public ReadPreference readPreference() {
        return this.readPreference;
    }
}

