/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.WriteConcern;
import io.vertx.core.json.JsonObject;
import java.util.concurrent.TimeUnit;

public class WriteConcernParser {
    private final WriteConcern writeConcern;

    public WriteConcernParser(ConnectionString connectionString, JsonObject config) {
        WriteConcern writeConcern = this.fromConfig(config);
        if (writeConcern == null && connectionString != null) {
            writeConcern = connectionString.getWriteConcern();
        }
        this.writeConcern = writeConcern;
    }

    private WriteConcern fromConfig(JsonObject config) {
        WriteConcern writeConcern = null;
        String wcs = config.getString("writeConcern");
        if (wcs != null) {
            writeConcern = WriteConcern.valueOf((String)wcs);
            if (writeConcern == null) {
                throw new IllegalArgumentException("Invalid WriteConcern " + wcs);
            }
        } else {
            Boolean safe = config.getBoolean("safe");
            Object w = config.getValue("w");
            Integer wtimeout = config.getInteger("wtimeoutMS", null);
            Boolean j = config.getBoolean("j", null);
            if (j == null) {
                j = config.getBoolean("journal", null);
            }
            if (w != null || wtimeout != null || j != null && j.booleanValue()) {
                writeConcern = w == null ? new WriteConcern(1) : this.getWriteConcern(w);
                if (wtimeout != null) {
                    writeConcern = writeConcern.withWTimeout((long)wtimeout.intValue(), TimeUnit.MILLISECONDS);
                }
                if (j != null) {
                    writeConcern = writeConcern.withJournal(j);
                }
            } else if (safe != null) {
                writeConcern = safe != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    private WriteConcern getWriteConcern(Object w) {
        WriteConcern wc;
        if (w instanceof String) {
            wc = new WriteConcern((String)w);
        } else if (w instanceof Integer) {
            wc = new WriteConcern(((Integer)w).intValue());
        } else {
            throw new IllegalArgumentException("Invalid type " + String.valueOf(w.getClass()) + " for w of WriteConcern");
        }
        return wc;
    }

    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

