/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.embeddedmongo;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.RuntimeConfigBuilder;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.runtime.Network;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.SLF4JLogDelegateFactory;
import org.slf4j.Logger;

public class EmbeddedMongoVerticle
extends AbstractVerticle {
    private MongodExecutable exe;
    private int actualPort;

    public void start() throws Exception {
        if (this.vertx != null && !this.context.isWorkerContext()) {
            throw new IllegalStateException("Must be started as worker verticle!");
        }
        JsonObject config = this.context.config();
        int port = config.getInteger("port", Integer.valueOf(0));
        String version = config.getString("version", "3.4.3");
        version = "V" + version.replace('.', '_');
        Version versionEnum = Version.valueOf((String)version);
        IMongodConfig embeddedConfig = new MongodConfigBuilder().version((IFeatureAwareVersion)versionEnum).net(port == 0 ? new Net() : new Net(port, Network.localhostIsIPv6())).build();
        Logger logger = (Logger)new SLF4JLogDelegateFactory().createDelegate(EmbeddedMongoVerticle.class.getCanonicalName()).unwrap();
        IRuntimeConfig runtimeConfig = new RuntimeConfigBuilder().defaultsWithLogger(Command.MongoD, logger).build();
        this.exe = (MongodExecutable)MongodStarter.getInstance((IRuntimeConfig)runtimeConfig).prepare((IExecutableProcessConfig)embeddedConfig);
        this.exe.start();
        this.actualPort = embeddedConfig.net().getPort();
    }

    public int actualPort() {
        return this.actualPort;
    }

    public void stop() {
        this.exe.stop();
    }
}

