/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindFluent;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientOptions;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.client.options.OperationOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MongoServiceImpl
implements MongoService {
    private static final Logger log = LoggerFactory.getLogger(MongoServiceImpl.class);
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final String ID_FIELD = "_id";
    private final Vertx vertx;
    private final JsonObject config;
    protected MongoClient mongo;
    protected MongoDatabase db;

    public MongoServiceImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public void start() {
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.config);
        this.mongo = MongoClients.create((MongoClientOptions)parser.options());
        String dbName = this.config.getString("db_name", "default_db");
        this.db = this.mongo.getDatabase(dbName);
        log.debug((Object)"mongoDB service started");
    }

    @Override
    public void stop() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        log.debug((Object)"mongoDB service stopped");
    }

    @Override
    public void save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.saveWithOptions(collection, document, null, resultHandler);
    }

    @Override
    public void saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        String id = document.getString(ID_FIELD);
        if (id == null) {
            coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> document.getString(ID_FIELD)));
        } else {
            coll.replaceOne((Object)new JsonObject().put(ID_FIELD, document.getString(ID_FIELD)), (Object)document, this.convertCallback(resultHandler, result -> null));
        }
    }

    @Override
    public void insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.insertWithOptions(collection, document, null, resultHandler);
    }

    @Override
    public void insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        boolean id = document.containsKey(ID_FIELD);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> {
            if (id) {
                return null;
            }
            return document.getString(ID_FIELD);
        }));
    }

    @Override
    public void update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.updateWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
    }

    @Override
    public void updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(update, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        if (options.isMulti()) {
            coll.updateMany((Object)query, (Object)update, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
        } else {
            coll.updateOne((Object)query, (Object)update, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
        }
    }

    @Override
    public void replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.replaceWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
    }

    @Override
    public void replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(replace, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        coll.replaceOne((Object)query, (Object)replace, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
    }

    @Override
    public void find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
    }

    @Override
    public void findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        FindFluent<JsonObject> view = this.doFind(collection, query, options);
        ArrayList results = new ArrayList();
        view.into(results, this.wrapCallback(resultHandler));
    }

    @Override
    public void findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.getCollection(collection).find((Object)query).projection((Object)fields).first(this.wrapCallback(resultHandler));
    }

    @Override
    public void count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.count((Object)query, this.wrapCallback(resultHandler));
    }

    @Override
    public void remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeWithOptions(collection, query, null, resultHandler);
    }

    @Override
    public void removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.deleteMany((Object)query, this.convertCallback(resultHandler, result -> null));
    }

    @Override
    public void removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeOneWithOptions(collection, query, null, resultHandler);
    }

    @Override
    public void removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.deleteOne((Object)query, this.convertCallback(resultHandler, result -> null));
    }

    @Override
    public void createCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.db.createCollection(collection, this.wrapCallback(resultHandler));
    }

    @Override
    public void getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.db.getCollectionNames(this.wrapCallback(resultHandler));
    }

    @Override
    public void dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.dropCollection(this.wrapCallback(resultHandler));
    }

    @Override
    public void runCommand(JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(command, "command cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.db.executeCommand((Object)command, this.db.getOptions().getReadPreference(), JsonObject.class, this.wrapCallback(resultHandler));
    }

    private <T, R> SingleResultCallback<T> convertCallback(Handler<AsyncResult<R>> resultHandler, Function<T, R> converter) {
        return (result, error) -> this.vertx.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(converter.apply(result)));
            }
        });
    }

    private <T> SingleResultCallback<T> wrapCallback(Handler<AsyncResult<T>> resultHandler) {
        return (result, error) -> this.vertx.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    private FindFluent<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        return this.doFind(collection, null, query, options);
    }

    private FindFluent<JsonObject> doFind(String collection, WriteOption writeOption, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        FindFluent find = coll.find((Object)query, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Object)options.getSort());
        }
        if (options.getFields() != null) {
            find.projection((Object)options.getFields());
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, WriteOption writeOption) {
        return this.db.getCollection(name, JsonObject.class, MongoServiceImpl.operationOptions(writeOption));
    }

    private static OperationOptions operationOptions(WriteOption writeOption) {
        OperationOptions.Builder options = OperationOptions.builder();
        if (writeOption != null) {
            options.writeConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return options.build();
    }

    private static com.mongodb.client.model.UpdateOptions mongoUpdateOptions(UpdateOptions options) {
        return new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
    }
}

