/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.WriteConcern;
import io.vertx.core.json.JsonObject;

class WriteConcernParser {
    private final WriteConcern writeConcern;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public WriteConcernParser(JsonObject config) {
        void var2_9;
        String wcs = config.getString("writeConcern");
        if (wcs != null) {
            WriteConcern writeConcern = WriteConcern.valueOf((String)wcs);
            if (writeConcern == null) {
                throw new IllegalArgumentException("Invalid WriteConcern " + wcs);
            }
        } else {
            Boolean safe = config.getBoolean("safe");
            Object w = config.getValue("w");
            int wtimeout = config.getInteger("wtimeoutMS", Integer.valueOf(0));
            boolean fsync = config.getBoolean("fsync", Boolean.valueOf(false));
            boolean j = config.getBoolean("j", Boolean.valueOf(false));
            if (!j) {
                j = config.getBoolean("journal", Boolean.valueOf(false));
            }
            if (w != null || wtimeout != 0 || fsync || j) {
                if (w == null) {
                    WriteConcern writeConcern = new WriteConcern(1, wtimeout, fsync, j);
                } else if (w instanceof String) {
                    WriteConcern writeConcern = new WriteConcern((String)w, wtimeout, fsync, j);
                } else {
                    if (!(w instanceof Integer)) throw new IllegalArgumentException("Invalid type " + w.getClass() + " for w of WriteConcern");
                    WriteConcern writeConcern = new WriteConcern(((Integer)w).intValue(), wtimeout, fsync, j);
                }
            } else if (safe != null) {
                WriteConcern writeConcern = safe != false ? WriteConcern.ACKNOWLEDGED : WriteConcern.UNACKNOWLEDGED;
            } else {
                Object var2_8 = null;
            }
        }
        this.writeConcern = var2_9;
    }

    public WriteConcern writeConcern() {
        return this.writeConcern;
    }
}

