/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.serviceproxy.ProxyHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MongoServiceVertxProxyHandler
extends ProxyHandler {
    private final Vertx vertx;
    private final MongoService service;
    private final String address;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public MongoServiceVertxProxyHandler(Vertx vertx, MongoService service, String address, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.address = address;
        this.timeoutSeconds = timeoutSeconds;
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        JsonObject json = (JsonObject)msg.body();
        String action = msg.headers().get("action");
        if (action == null) {
            throw new IllegalStateException("action not specified");
        }
        this.accessed();
        switch (action) {
            case "save": {
                this.service.save((String)json.getValue("collection"), (JsonObject)json.getValue("document"), this.createHandler(msg));
                break;
            }
            case "saveWithOptions": {
                this.service.saveWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("document"), WriteOption.valueOf(json.getString("writeOption")), this.createHandler(msg));
                break;
            }
            case "insert": {
                this.service.insert((String)json.getValue("collection"), (JsonObject)json.getValue("document"), this.createHandler(msg));
                break;
            }
            case "insertWithOptions": {
                this.service.insertWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("document"), WriteOption.valueOf(json.getString("writeOption")), this.createHandler(msg));
                break;
            }
            case "update": {
                this.service.update((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), this.createHandler(msg));
                break;
            }
            case "updateWithOptions": {
                this.service.updateWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), new UpdateOptions(json.getJsonObject("options")), this.createHandler(msg));
                break;
            }
            case "replace": {
                this.service.replace((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), this.createHandler(msg));
                break;
            }
            case "replaceWithOptions": {
                this.service.replaceWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), new UpdateOptions(json.getJsonObject("options")), this.createHandler(msg));
                break;
            }
            case "find": {
                this.service.find((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createListHandler(msg));
                break;
            }
            case "findWithOptions": {
                this.service.findWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), new FindOptions(json.getJsonObject("options")), this.createListHandler(msg));
                break;
            }
            case "findOne": {
                this.service.findOne((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("fields"), this.createHandler(msg));
                break;
            }
            case "count": {
                this.service.count((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                break;
            }
            case "remove": {
                this.service.remove((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                break;
            }
            case "removeWithOptions": {
                this.service.removeWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), WriteOption.valueOf(json.getString("writeOption")), this.createHandler(msg));
                break;
            }
            case "removeOne": {
                this.service.removeOne((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                break;
            }
            case "removeOneWithOptions": {
                this.service.removeOneWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), WriteOption.valueOf(json.getString("writeOption")), this.createHandler(msg));
                break;
            }
            case "createCollection": {
                this.service.createCollection((String)json.getValue("collectionName"), this.createHandler(msg));
                break;
            }
            case "getCollections": {
                this.service.getCollections(this.createListHandler(msg));
                break;
            }
            case "dropCollection": {
                this.service.dropCollection((String)json.getValue("collection"), this.createHandler(msg));
                break;
            }
            case "runCommand": {
                this.service.runCommand((JsonObject)json.getValue("command"), this.createHandler(msg));
                break;
            }
            case "start": {
                this.service.start();
                break;
            }
            case "stop": {
                this.service.stop();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid action: " + action);
            }
        }
    }

    private <T> Handler<AsyncResult<T>> createHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply(res.result());
            }
        };
    }

    private <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    private <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    private Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                msg.fail(-1, res.cause().getMessage());
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

