/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientOptions;
import com.mongodb.async.client.MongoClients;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.impl.JsonObjectBsonAdapter;
import io.vertx.ext.mongo.impl.config.MongoClientOptionsParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.bson.conversions.Bson;

public class MongoServiceImpl
implements MongoService {
    private static final Logger log = LoggerFactory.getLogger(MongoServiceImpl.class);
    private static final UpdateOptions DEFAULT_UPDATE_OPTIONS = new UpdateOptions();
    private static final FindOptions DEFAULT_FIND_OPTIONS = new FindOptions();
    private static final String ID_FIELD = "_id";
    private final Vertx vertx;
    private final JsonObject config;
    protected MongoClient mongo;
    protected MongoDatabase db;

    public MongoServiceImpl(Vertx vertx, JsonObject config) {
        this.vertx = vertx;
        this.config = config;
    }

    @Override
    public void start() {
        MongoClientOptionsParser parser = new MongoClientOptionsParser(this.config);
        this.mongo = MongoClients.create((MongoClientOptions)parser.options());
        String dbName = this.config.getString("db_name", "default_db");
        this.db = this.mongo.getDatabase(dbName);
        log.debug((Object)"mongoDB service started");
    }

    @Override
    public void stop() {
        if (this.mongo != null) {
            this.mongo.close();
        }
        log.debug((Object)"mongoDB service stopped");
    }

    @Override
    public MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.saveWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        String id = document.getString(ID_FIELD);
        if (id == null) {
            coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> document.getString(ID_FIELD)));
        } else {
            coll.replaceOne((Bson)this.wrap(new JsonObject().put(ID_FIELD, document.getString(ID_FIELD))), (Object)document, this.convertCallback(resultHandler, result -> null));
        }
        return this;
    }

    @Override
    public MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.insertWithOptions(collection, document, null, resultHandler);
        return this;
    }

    @Override
    public MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(document, "document cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        boolean id = document.containsKey(ID_FIELD);
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        coll.insertOne((Object)document, this.convertCallback(resultHandler, wr -> {
            if (id) {
                return null;
            }
            return document.getString(ID_FIELD);
        }));
        return this;
    }

    @Override
    public MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.updateWithOptions(collection, query, update, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(update, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(query);
        JsonObjectBsonAdapter bupdate = this.wrap(update);
        if (options.isMulti()) {
            coll.updateMany((Bson)bquery, (Bson)bupdate, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
        } else {
            coll.updateOne((Bson)bquery, (Bson)bupdate, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
        }
        return this;
    }

    @Override
    public MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.replaceWithOptions(collection, query, replace, DEFAULT_UPDATE_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(replace, "update cannot be null");
        Objects.requireNonNull(options, "options cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, options.getWriteOption());
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.replaceOne((Bson)bquery, (Object)replace, MongoServiceImpl.mongoUpdateOptions(options), this.convertCallback(resultHandler, result -> null));
        return this;
    }

    @Override
    public MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.findWithOptions(collection, query, DEFAULT_FIND_OPTIONS, resultHandler);
        return this;
    }

    @Override
    public MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        FindIterable<JsonObject> view = this.doFind(collection, query, options);
        ArrayList results = new ArrayList();
        view.into(results, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObjectBsonAdapter bquery = this.wrap(query);
        JsonObjectBsonAdapter bfields = this.wrap(fields);
        this.getCollection(collection).find((Bson)bquery).projection((Bson)bfields).first(this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        JsonObjectBsonAdapter bquery = this.wrap(query);
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.count((Bson)bquery, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.deleteMany((Bson)bquery, this.convertCallback(resultHandler, result -> null));
        return this;
    }

    @Override
    public MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.removeOneWithOptions(collection, query, null, resultHandler);
        return this;
    }

    @Override
    public MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(query, "query cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        coll.deleteOne((Bson)bquery, this.convertCallback(resultHandler, result -> null));
        return this;
    }

    @Override
    public MongoService createCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.db.createCollection(collection, this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        ArrayList names = new ArrayList();
        this.db.listCollectionNames().into(names, (res, error) -> this.vertx.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)names));
            }
        }));
        return this;
    }

    @Override
    public MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        Objects.requireNonNull(collection, "collection cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        MongoCollection<JsonObject> coll = this.getCollection(collection);
        coll.dropCollection(this.wrapCallback(resultHandler));
        return this;
    }

    @Override
    public MongoService runCommand(JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        Objects.requireNonNull(command, "command cannot be null");
        Objects.requireNonNull(resultHandler, "resultHandler cannot be null");
        this.db.executeCommand((Bson)this.wrap(command), JsonObject.class, this.wrapCallback(resultHandler));
        return this;
    }

    private <T, R> SingleResultCallback<T> convertCallback(Handler<AsyncResult<R>> resultHandler, Function<T, R> converter) {
        return (result, error) -> this.vertx.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(converter.apply(result)));
            }
        });
    }

    private <T> SingleResultCallback<T> wrapCallback(Handler<AsyncResult<T>> resultHandler) {
        return (result, error) -> this.vertx.runOnContext(v -> {
            if (error != null) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)error));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)result));
            }
        });
    }

    private FindIterable<JsonObject> doFind(String collection, JsonObject query, FindOptions options) {
        return this.doFind(collection, null, query, options);
    }

    private FindIterable<JsonObject> doFind(String collection, WriteOption writeOption, JsonObject query, FindOptions options) {
        MongoCollection<JsonObject> coll = this.getCollection(collection, writeOption);
        JsonObjectBsonAdapter bquery = this.wrap(query);
        FindIterable find = coll.find((Bson)bquery, JsonObject.class);
        if (options.getLimit() != -1) {
            find.limit(options.getLimit());
        }
        if (options.getSkip() > 0) {
            find.skip(options.getSkip());
        }
        if (options.getSort() != null) {
            find.sort((Bson)this.wrap(options.getSort()));
        }
        if (options.getFields() != null) {
            find.projection((Bson)this.wrap(options.getFields()));
        }
        return find;
    }

    private MongoCollection<JsonObject> getCollection(String name) {
        return this.getCollection(name, null);
    }

    private MongoCollection<JsonObject> getCollection(String name, WriteOption writeOption) {
        MongoCollection coll = this.db.getCollection(name, JsonObject.class);
        if (coll != null && writeOption != null) {
            coll = coll.withWriteConcern(WriteConcern.valueOf((String)writeOption.name()));
        }
        return coll;
    }

    private static com.mongodb.client.model.UpdateOptions mongoUpdateOptions(UpdateOptions options) {
        return new com.mongodb.client.model.UpdateOptions().upsert(options.isUpsert());
    }

    private JsonObjectBsonAdapter wrap(JsonObject jsonObject) {
        return jsonObject == null ? null : new JsonObjectBsonAdapter(jsonObject);
    }
}

